/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.RestModule;

@ConfiguresRestClient
public class RestClientModule<S, A>
extends RestModule {
    protected final TypeToken<S> syncClientType;
    protected final TypeToken<A> asyncClientType;

    protected RestClientModule(Map<Class<?>, Class<?>> sync2Async) {
        super(sync2Async);
        this.syncClientType = RestClientModule.checkBound(new TypeToken<S>(((Object)((Object)this)).getClass()){
            private static final long serialVersionUID = 1L;
        });
        this.asyncClientType = RestClientModule.checkBound(new TypeToken<A>(((Object)((Object)this)).getClass()){
            private static final long serialVersionUID = 1L;
        });
    }

    private static <T> TypeToken<T> checkBound(TypeToken<T> type) throws IllegalStateException {
        Preconditions.checkState((!(type.getType() instanceof TypeVariable) ? 1 : 0) != 0, (String)"unbound type variable: %s, use ctor that explicitly assigns this", (Object[])new Object[]{type});
        return type;
    }

    protected RestClientModule() {
        this((Map<Class<?>, Class<?>>)ImmutableMap.of());
    }

    public RestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType) {
        this(syncClientType, asyncClientType, (Map<Class<?>, Class<?>>)ImmutableMap.of());
    }

    public RestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        super(sync2Async);
        this.syncClientType = RestClientModule.checkBound(syncClientType);
        this.asyncClientType = RestClientModule.checkBound(asyncClientType);
    }

    @Override
    protected void configure() {
        super.configure();
        BinderUtils.bindHttpApi(this.binder(), this.syncClientType.getRawType(), this.asyncClientType.getRawType());
        this.bindErrorHandlers();
        this.bindRetryHandlers();
    }

    protected void bindRetryHandlers() {
    }

    protected void bindErrorHandlers() {
    }
}

