/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.concurrent.Callable;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;

class ConstantHandleSupplier
implements HandleSupplier {
    private final Handle handle;

    static HandleSupplier of(Handle handle) {
        return new ConstantHandleSupplier(handle);
    }

    ConstantHandleSupplier(Handle handle) {
        this.handle = handle;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.handle.getConfig();
    }

    @Override
    public Handle getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        ExtensionMethod oldExtensionMethod = this.handle.getExtensionMethod();
        try {
            V v;
            this.handle.setExtensionMethod(extensionMethod);
            ConfigRegistry oldConfig = this.handle.getConfig();
            try {
                this.handle.setConfig(config);
                v = task.call();
                this.handle.setConfig(oldConfig);
            }
            catch (Throwable throwable) {
                this.handle.setConfig(oldConfig);
                throw throwable;
            }
            return v;
        }
        finally {
            this.handle.setExtensionMethod(oldExtensionMethod);
        }
    }
}

