/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.array.SqlArrayArgument;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

public class SqlArrayArgumentFactory
implements ArgumentFactory {
    @Override
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        Class<?> erasedType = GenericTypes.getErasedType(type);
        if (!erasedType.isArray() && !Collection.class.isAssignableFrom(erasedType)) {
            return Optional.empty();
        }
        if (value == null) {
            return Optional.of(new NullArgument(2003));
        }
        Function<Type, Optional> lookup = eT -> config.get(SqlArrayTypes.class).findFor((Type)eT);
        if (erasedType.isArray()) {
            Class<?> elementType = erasedType.getComponentType();
            return lookup.apply(elementType).map(arrayType -> new SqlArrayArgument(arrayType, value));
        }
        return GenericTypes.findGenericParameter(type, Collection.class).flatMap(lookup).map(arrayType -> new SqlArrayArgument(arrayType, value));
    }
}

