/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.generic.internal;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jdbi.v3.core.generic.internal.Preconditions;
import org.jdbi.v3.core.generic.internal.TypeCapture;
import org.jdbi.v3.core.generic.internal.TypeParameter;
import org.jdbi.v3.core.generic.internal.TypeResolver;
import org.jdbi.v3.core.generic.internal.TypeVisitor;
import org.jdbi.v3.core.generic.internal.Types;

public class TypeToken<T>
extends TypeCapture<T> {
    private final Type runtimeType;
    private transient TypeResolver typeResolver;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", this.runtimeType);
    }

    private TypeToken(Type type) {
        this.runtimeType = Preconditions.checkNotNull(type, "type", new Object[0]);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParam, TypeToken<X> typeArg) {
        TypeResolver resolver = new TypeResolver().where(Collections.singletonMap(new TypeResolver.TypeVariableKey(typeParam.typeVariable), typeArg.runtimeType));
        return new SimpleTypeToken(resolver.resolveType(this.runtimeType));
    }

    public final TypeToken<?> resolveType(Type type) {
        Preconditions.checkNotNull(type, "type", new Object[0]);
        TypeResolver resolver = this.typeResolver;
        if (resolver == null) {
            resolver = this.typeResolver = TypeResolver.accordingTo(this.runtimeType);
        }
        return TypeToken.of(resolver.resolveType(type));
    }

    public final Type getType() {
        return this.runtimeType;
    }

    public final Class<? super T> getRawType() {
        Class<T> rawType;
        Class<T> result = rawType = this.getRawTypes().iterator().next();
        return result;
    }

    private Set<Class<? super T>> getRawTypes() {
        final LinkedHashSet builder = new LinkedHashSet();
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                this.visit(t.getBounds());
            }

            @Override
            void visitWildcardType(WildcardType t) {
                this.visit(t.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType t) {
                builder.add((Class)t.getRawType());
            }

            @Override
            void visitClass(Class<?> t) {
                builder.add(t);
            }

            @Override
            void visitGenericArrayType(GenericArrayType t) {
                builder.add(Types.getArrayClass(TypeToken.of(t.getGenericComponentType()).getRawType()));
            }
        }.visit(this.runtimeType);
        Set<Class<? super T>> result = Collections.unmodifiableSet(builder);
        return result;
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        SimpleTypeToken(Type type) {
            super(type);
        }
    }
}

