/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class MapMapper
implements RowMapper<Map<String, Object>> {
    private final boolean foldCase;

    public MapMapper() {
        this(true);
    }

    public MapMapper(boolean foldCase) {
        this.foldCase = foldCase;
    }

    @Override
    public Map<String, Object> map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<Map<String, Object>> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        ResultSetMetaData m = rs.getMetaData();
        int columnCount = m.getColumnCount();
        String[] columnNames = new String[columnCount + 1];
        for (int i = 1; i <= columnCount; ++i) {
            String key = m.getColumnName(i);
            String alias = m.getColumnLabel(i);
            if (alias == null) {
                alias = key;
            }
            if (this.foldCase) {
                alias = alias.toLowerCase(Locale.ROOT);
            }
            columnNames[i] = alias;
        }
        return (r, c) -> {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                row.put(columnNames[i], rs.getObject(i));
            }
            return row;
        };
    }
}

