/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.jdbi.v3.core.internal.lexer.ColonStatementLexer;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class ColonPrefixSqlParser
implements SqlParser {
    private final Map<String, ParsedSql> cache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public ParsedSql parse(String sql, StatementContext ctx) {
        try {
            return this.cache.computeIfAbsent(sql, this::internalParse);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e, ctx);
        }
    }

    @Override
    public String nameParameter(String rawName, StatementContext ctx) {
        return ":" + rawName;
    }

    private ParsedSql internalParse(String sql) throws IllegalArgumentException {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        ColonStatementLexer lexer = new ColonStatementLexer((CharStream)new ANTLRStringStream(sql));
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 5: 
                case 8: 
                case 12: 
                case 17: {
                    parsedSql.append(t.getText());
                    break;
                }
                case 14: {
                    parsedSql.appendNamedParameter(t.getText().substring(1));
                    break;
                }
                case 15: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 10: {
                    parsedSql.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

