/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.inlined.org.antlr.v4.runtime.$CharStreams;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;

public class Script
extends SqlStatement<Script> {
    public Script(Handle handle, CharSequence sql) {
        super(handle, sql);
    }

    public Script(Handle handle, String sql) {
        super(handle, sql);
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        try (Batch b = this.getHandle().createBatch();){
            statements.forEach(b::add);
            int[] nArray = b.execute();
            return nArray;
        }
    }

    public void executeAsSeparateStatements() {
        for (String s : this.getStatements()) {
            this.getHandle().execute(s, new Object[0]);
        }
    }

    public List<String> getStatements() {
        return this.splitToStatements(this.getConfig(SqlStatements.class).getTemplateEngine().render(this.getSql(), this.getContext()));
    }

    private List<String> splitToStatements(String script) {
        SqlScriptParser.ScriptTokenHandler scriptTokenHandler = new SqlScriptParser.ScriptTokenHandler();
        String lastStatement = new SqlScriptParser(scriptTokenHandler).parse($CharStreams.fromString(script));
        return scriptTokenHandler.addStatement(lastStatement);
    }
}

