/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.Unchecked;

class OnDemandExtensions {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;

    private OnDemandExtensions() {
        throw new UtilityClassException();
    }

    static <E> E create(Jdbi db, Class<E> extensionType) {
        InvocationHandler handler = (proxy, method, args) -> {
            if (EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (TOSTRING_METHOD.equals(method)) {
                return extensionType + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            return db.withExtension(extensionType, extension -> OnDemandExtensions.invoke(extension, method, args));
        };
        return extensionType.cast(Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, handler));
    }

    private static Object invoke(Object target, Method method, Object[] args) {
        if (Proxy.isProxyClass(target.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(target);
            return Unchecked.function(params -> handler.invoke(target, method, (Object[])params)).apply(args);
        }
        MethodHandle handle = Unchecked.function(MethodHandles.lookup()::unreflect).apply(method).bindTo(target);
        return Unchecked.function(handle::invokeWithArguments).apply(args);
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException wat) {
            throw new IllegalStateException("JVM error", wat);
        }
    }
}

