/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.internal.StatementBinder;
import org.jdbi.v3.core.argument.internal.strategies.LoggableBinderArgument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

abstract class DelegatingArgumentFactory
implements ArgumentFactory {
    private final Map<Class<?>, Function<?, Argument>> builders = new IdentityHashMap();

    DelegatingArgumentFactory() {
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        Class<?> expectedClass = GenericTypes.getErasedType(expectedType);
        if (value != null && expectedClass == Object.class) {
            expectedClass = value.getClass();
        }
        Function<?, Argument> reusable = this.builders.get(expectedClass);
        return Optional.ofNullable(reusable).map(r -> (Argument)r.apply(value));
    }

    <T> void register(Class<T> klass, int sqlType, StatementBinder<T> binder) {
        this.builders.put(klass, value -> value == null ? new NullArgument(sqlType) : new LoggableBinderArgument<Object>(value, binder));
    }
}

