/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jeasy.random.ArrayPopulator;
import org.jeasy.random.CollectionPopulator;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.FieldPopulator;
import org.jeasy.random.MapPopulator;
import org.jeasy.random.ObjectCreationException;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.RegistriesRandomizerProvider;
import org.jeasy.random.api.ContextAwareRandomizer;
import org.jeasy.random.api.ExclusionPolicy;
import org.jeasy.random.api.ObjectFactory;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerContext;
import org.jeasy.random.api.RandomizerProvider;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.randomizers.misc.EnumRandomizer;
import org.jeasy.random.util.ReflectionUtils;

public class EasyRandom
extends Random {
    private EasyRandomParameters parameters;
    private final FieldPopulator fieldPopulator;
    private final ArrayPopulator arrayPopulator;
    private final Map<Class, EnumRandomizer> enumRandomizersByType;
    private final RandomizerProvider randomizerProvider;
    private final ObjectFactory objectFactory;
    private final ExclusionPolicy exclusionPolicy;

    public EasyRandom() {
        this(new EasyRandomParameters());
    }

    public EasyRandom(EasyRandomParameters easyRandomParameters) {
        Objects.requireNonNull(easyRandomParameters, "Parameters must not be null");
        super.setSeed(easyRandomParameters.getSeed());
        LinkedHashSet<RandomizerRegistry> registries = this.setupRandomizerRegistries(easyRandomParameters);
        RandomizerProvider customRandomizerProvider = easyRandomParameters.getRandomizerProvider();
        this.randomizerProvider = customRandomizerProvider == null ? new RegistriesRandomizerProvider() : customRandomizerProvider;
        this.randomizerProvider.setRandomizerRegistries(registries);
        this.objectFactory = easyRandomParameters.getObjectFactory();
        this.arrayPopulator = new ArrayPopulator(this);
        CollectionPopulator collectionPopulator = new CollectionPopulator(this);
        MapPopulator mapPopulator = new MapPopulator(this, this.objectFactory);
        this.enumRandomizersByType = new ConcurrentHashMap<Class, EnumRandomizer>();
        this.fieldPopulator = new FieldPopulator(this, this.randomizerProvider, this.arrayPopulator, collectionPopulator, mapPopulator);
        this.exclusionPolicy = easyRandomParameters.getExclusionPolicy();
        this.parameters = easyRandomParameters;
    }

    public <T> T nextObject(Class<T> type) {
        return this.doPopulateBean(type, new RandomizationContext(type, this.parameters));
    }

    public <T> Stream<T> objects(Class<T> type, int streamSize) {
        if (streamSize < 0) {
            throw new IllegalArgumentException("The stream size must be positive");
        }
        return Stream.generate(() -> this.nextObject(type)).limit(streamSize);
    }

    <T> T doPopulateBean(Class<T> type, RandomizationContext context) {
        if (this.exclusionPolicy.shouldBeExcluded(type, (RandomizerContext)context)) {
            return null;
        }
        try {
            Randomizer<T> randomizer = this.randomizerProvider.getRandomizerByType(type, context);
            if (randomizer != null) {
                if (randomizer instanceof ContextAwareRandomizer) {
                    ((ContextAwareRandomizer)randomizer).setRandomizerContext(context);
                }
                return randomizer.getRandomValue();
            }
            if (!ReflectionUtils.isIntrospectable(type)) {
                return this.randomize(type, context);
            }
            if (context.hasAlreadyRandomizedType(type)) {
                return (T)context.getPopulatedBean(type);
            }
            T result = this.objectFactory.createInstance(type, context);
            context.setRandomizedObject(result);
            context.addPopulatedBean(type, result);
            List<Field> fields = ReflectionUtils.getDeclaredFields(result);
            fields.addAll(ReflectionUtils.getInheritedFields(result.getClass()));
            if (type.getEnclosingClass() != null) {
                fields.removeIf(field -> field.getName().equals("this$0"));
            }
            this.populateFields(fields, result, context);
            return result;
        }
        catch (Throwable e) {
            if (this.parameters.isIgnoreRandomizationErrors()) {
                return null;
            }
            throw new ObjectCreationException("Unable to create a random instance of type " + type, e);
        }
    }

    private <T> T randomize(Class<T> type, RandomizationContext context) {
        if (ReflectionUtils.isEnumType(type)) {
            if (!this.enumRandomizersByType.containsKey(type)) {
                this.enumRandomizersByType.put(type, new EnumRandomizer<T>(type, this.parameters.getSeed()));
            }
            return (T)this.enumRandomizersByType.get(type).getRandomValue();
        }
        if (ReflectionUtils.isArrayType(type)) {
            return (T)this.arrayPopulator.getRandomArray(type, context);
        }
        if (ReflectionUtils.isCollectionType(type)) {
            return (T)ReflectionUtils.getEmptyImplementationForCollectionInterface(type);
        }
        if (ReflectionUtils.isMapType(type)) {
            return (T)ReflectionUtils.getEmptyImplementationForMapInterface(type);
        }
        return null;
    }

    private <T> void populateFields(List<Field> fields, T result, RandomizationContext context) throws IllegalAccessException {
        for (Field field : fields) {
            this.populateField(field, result, context);
        }
    }

    private <T> void populateField(Field field, T result, RandomizationContext context) throws IllegalAccessException {
        if (this.exclusionPolicy.shouldBeExcluded(field, (RandomizerContext)context)) {
            return;
        }
        if (!this.parameters.isOverrideDefaultInitialization() && ReflectionUtils.getFieldValue(result, field) != null && !ReflectionUtils.isPrimitiveFieldWithDefaultValue(result, field)) {
            return;
        }
        this.fieldPopulator.populateField(result, field, context);
    }

    private LinkedHashSet<RandomizerRegistry> setupRandomizerRegistries(EasyRandomParameters parameters) {
        LinkedHashSet<RandomizerRegistry> registries = new LinkedHashSet<RandomizerRegistry>();
        registries.add(parameters.getCustomRandomizerRegistry());
        registries.add(parameters.getExclusionRandomizerRegistry());
        registries.addAll(parameters.getUserRegistries());
        registries.addAll(this.loadRegistries());
        registries.forEach(registry -> registry.init(parameters));
        return registries;
    }

    private Collection<RandomizerRegistry> loadRegistries() {
        ArrayList<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
        ServiceLoader.load(RandomizerRegistry.class).forEach(registries::add);
        return registries;
    }
}

