/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jeasy.random.ExclusionChecker;
import org.jeasy.random.ObjenesisObjectFactory;
import org.jeasy.random.api.ExclusionPolicy;
import org.jeasy.random.api.ObjectFactory;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerProvider;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.randomizers.registry.CustomRandomizerRegistry;
import org.jeasy.random.randomizers.registry.ExclusionRandomizerRegistry;

public class EasyRandomParameters {
    public static final long DEFAULT_SEED = 123L;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final Range<Integer> DEFAULT_COLLECTION_SIZE_RANGE = new Range<Integer>(1, 100);
    public static final int DEFAULT_OBJECT_POOL_SIZE = 10;
    public static final int DEFAULT_RANDOMIZATION_DEPTH = Integer.MAX_VALUE;
    public static final Range<Integer> DEFAULT_STRING_LENGTH_RANGE = new Range<Integer>(1, 32);
    public static final int DEFAULT_DATE_RANGE = 10;
    private static final ZonedDateTime REFERENCE_DATE = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC+1"));
    public static final Range<ZonedDateTime> DEFAULT_DATES_RANGE = new Range<ZonedDateTime>(REFERENCE_DATE.minusYears(10L), REFERENCE_DATE.plusYears(10L));
    private long seed = 123L;
    private int objectPoolSize = 10;
    private int randomizationDepth;
    private Charset charset = DEFAULT_CHARSET;
    private boolean scanClasspathForConcreteTypes = false;
    private boolean overrideDefaultInitialization = false;
    private boolean ignoreRandomizationErrors = false;
    private Range<Integer> collectionSizeRange;
    private Range<Integer> stringLengthRange;
    private Range<LocalDate> dateRange;
    private Range<LocalTime> timeRange;
    private ExclusionPolicy exclusionPolicy;
    private ObjectFactory objectFactory;
    private RandomizerProvider randomizerProvider;
    private CustomRandomizerRegistry customRandomizerRegistry;
    private ExclusionRandomizerRegistry exclusionRandomizerRegistry;
    private Set<RandomizerRegistry> userRegistries;
    private Set<Predicate<Field>> fieldExclusionPredicates;
    private Set<Predicate<Class<?>>> typeExclusionPredicates;

    public EasyRandomParameters() {
        this.randomizationDepth = Integer.MAX_VALUE;
        this.dateRange = new Range<LocalDate>(DEFAULT_DATES_RANGE.getMin().toLocalDate(), DEFAULT_DATES_RANGE.getMax().toLocalDate());
        this.timeRange = new Range<LocalTime>(LocalTime.MIN, LocalTime.MAX);
        this.collectionSizeRange = DEFAULT_COLLECTION_SIZE_RANGE;
        this.stringLengthRange = DEFAULT_STRING_LENGTH_RANGE;
        this.customRandomizerRegistry = new CustomRandomizerRegistry();
        this.exclusionRandomizerRegistry = new ExclusionRandomizerRegistry();
        this.userRegistries = new LinkedHashSet<RandomizerRegistry>();
        this.fieldExclusionPredicates = new HashSet<Predicate<Field>>();
        this.typeExclusionPredicates = new HashSet();
        this.exclusionPolicy = new ExclusionChecker();
        this.objectFactory = new ObjenesisObjectFactory();
    }

    public Range<Integer> getCollectionSizeRange() {
        return this.collectionSizeRange;
    }

    public void setCollectionSizeRange(Range<Integer> collectionSizeRange) {
        this.collectionSizeRange = collectionSizeRange;
    }

    public Range<LocalDate> getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(Range<LocalDate> dateRange) {
        this.dateRange = dateRange;
    }

    public Range<LocalTime> getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(Range<LocalTime> timeRange) {
        this.timeRange = timeRange;
    }

    public Range<Integer> getStringLengthRange() {
        return this.stringLengthRange;
    }

    public void setStringLengthRange(Range<Integer> stringLengthRange) {
        this.stringLengthRange = stringLengthRange;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int getObjectPoolSize() {
        return this.objectPoolSize;
    }

    public void setObjectPoolSize(int objectPoolSize) {
        if (objectPoolSize < 1) {
            throw new IllegalArgumentException("objectPoolSize must be >= 1");
        }
        this.objectPoolSize = objectPoolSize;
    }

    public int getRandomizationDepth() {
        return this.randomizationDepth;
    }

    public void setRandomizationDepth(int randomizationDepth) {
        if (randomizationDepth < 1) {
            throw new IllegalArgumentException("randomizationDepth must be >= 1");
        }
        this.randomizationDepth = randomizationDepth;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        this.charset = charset;
    }

    public boolean isScanClasspathForConcreteTypes() {
        return this.scanClasspathForConcreteTypes;
    }

    public void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }

    public boolean isOverrideDefaultInitialization() {
        return this.overrideDefaultInitialization;
    }

    public void setOverrideDefaultInitialization(boolean overrideDefaultInitialization) {
        this.overrideDefaultInitialization = overrideDefaultInitialization;
    }

    public boolean isIgnoreRandomizationErrors() {
        return this.ignoreRandomizationErrors;
    }

    public void setIgnoreRandomizationErrors(boolean ignoreRandomizationErrors) {
        this.ignoreRandomizationErrors = ignoreRandomizationErrors;
    }

    public ExclusionPolicy getExclusionPolicy() {
        return this.exclusionPolicy;
    }

    public void setExclusionPolicy(ExclusionPolicy exclusionPolicy) {
        Objects.requireNonNull(exclusionPolicy, "Exclusion policy must not be null");
        this.exclusionPolicy = exclusionPolicy;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        Objects.requireNonNull(objectFactory, "Object factory must not be null");
        this.objectFactory = objectFactory;
    }

    public RandomizerProvider getRandomizerProvider() {
        return this.randomizerProvider;
    }

    public void setRandomizerProvider(RandomizerProvider randomizerProvider) {
        Objects.requireNonNull(this.objectFactory, "Randomizer provider must not be null");
        this.randomizerProvider = randomizerProvider;
    }

    public Set<Predicate<Field>> getFieldExclusionPredicates() {
        return this.fieldExclusionPredicates;
    }

    public Set<Predicate<Class<?>>> getTypeExclusionPredicates() {
        return this.typeExclusionPredicates;
    }

    CustomRandomizerRegistry getCustomRandomizerRegistry() {
        return this.customRandomizerRegistry;
    }

    ExclusionRandomizerRegistry getExclusionRandomizerRegistry() {
        return this.exclusionRandomizerRegistry;
    }

    Set<RandomizerRegistry> getUserRegistries() {
        return this.userRegistries;
    }

    public <T> EasyRandomParameters randomize(Predicate<Field> predicate, Randomizer<T> randomizer) {
        Objects.requireNonNull(predicate, "Predicate must not be null");
        Objects.requireNonNull(randomizer, "Randomizer must not be null");
        this.customRandomizerRegistry.registerRandomizer(predicate, randomizer);
        return this;
    }

    public <T> EasyRandomParameters randomize(Class<T> type, Randomizer<T> randomizer) {
        Objects.requireNonNull(type, "Type must not be null");
        Objects.requireNonNull(randomizer, "Randomizer must not be null");
        this.customRandomizerRegistry.registerRandomizer(type, randomizer);
        return this;
    }

    public EasyRandomParameters excludeField(Predicate<Field> predicate) {
        Objects.requireNonNull(predicate, "Predicate must not be null");
        this.fieldExclusionPredicates.add(predicate);
        this.exclusionRandomizerRegistry.addFieldPredicate(predicate);
        return this;
    }

    public EasyRandomParameters excludeType(Predicate<Class<?>> predicate) {
        Objects.requireNonNull(predicate, "Predicate must not be null");
        this.typeExclusionPredicates.add(predicate);
        this.exclusionRandomizerRegistry.addTypePredicate(predicate);
        return this;
    }

    public EasyRandomParameters exclusionPolicy(ExclusionPolicy exclusionPolicy) {
        this.setExclusionPolicy(exclusionPolicy);
        return this;
    }

    public EasyRandomParameters objectFactory(ObjectFactory objectFactory) {
        this.setObjectFactory(objectFactory);
        return this;
    }

    public EasyRandomParameters randomizerProvider(RandomizerProvider randomizerProvider) {
        this.setRandomizerProvider(randomizerProvider);
        return this;
    }

    public EasyRandomParameters seed(long seed) {
        this.setSeed(seed);
        return this;
    }

    public EasyRandomParameters collectionSizeRange(int minCollectionSize, int maxCollectionSize) {
        if (minCollectionSize < 0) {
            throw new IllegalArgumentException("minCollectionSize must be >= 0");
        }
        if (minCollectionSize > maxCollectionSize) {
            throw new IllegalArgumentException(String.format("minCollectionSize (%s) must be <= than maxCollectionSize (%s)", minCollectionSize, maxCollectionSize));
        }
        this.setCollectionSizeRange(new Range<Integer>(minCollectionSize, maxCollectionSize));
        return this;
    }

    public EasyRandomParameters stringLengthRange(int minStringLength, int maxStringLength) {
        if (minStringLength < 0) {
            throw new IllegalArgumentException("minStringLength must be >= 0");
        }
        if (minStringLength > maxStringLength) {
            throw new IllegalArgumentException(String.format("minStringLength (%s) must be <= than maxStringLength (%s)", minStringLength, maxStringLength));
        }
        this.setStringLengthRange(new Range<Integer>(minStringLength, maxStringLength));
        return this;
    }

    public EasyRandomParameters objectPoolSize(int objectPoolSize) {
        this.setObjectPoolSize(objectPoolSize);
        return this;
    }

    public EasyRandomParameters randomizationDepth(int randomizationDepth) {
        this.setRandomizationDepth(randomizationDepth);
        return this;
    }

    public EasyRandomParameters charset(Charset charset) {
        this.setCharset(charset);
        return this;
    }

    public EasyRandomParameters dateRange(LocalDate min, LocalDate max) {
        if (min.isAfter(max)) {
            throw new IllegalArgumentException("Min date should be before max date");
        }
        this.setDateRange(new Range<LocalDate>(min, max));
        return this;
    }

    public EasyRandomParameters timeRange(LocalTime min, LocalTime max) {
        if (min.isAfter(max)) {
            throw new IllegalArgumentException("Min time should be before max time");
        }
        this.setTimeRange(new Range<LocalTime>(min, max));
        return this;
    }

    public EasyRandomParameters randomizerRegistry(RandomizerRegistry registry) {
        Objects.requireNonNull(registry, "Registry must not be null");
        this.userRegistries.add(registry);
        return this;
    }

    public EasyRandomParameters scanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.setScanClasspathForConcreteTypes(scanClasspathForConcreteTypes);
        return this;
    }

    public EasyRandomParameters ignoreRandomizationErrors(boolean ignoreRandomizationErrors) {
        this.setIgnoreRandomizationErrors(ignoreRandomizationErrors);
        return this;
    }

    public EasyRandomParameters overrideDefaultInitialization(boolean overrideDefaultInitialization) {
        this.setOverrideDefaultInitialization(overrideDefaultInitialization);
        return this;
    }

    public static class Range<T> {
        private T min;
        private T max;

        public Range(T min, T max) {
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }

        public void setMin(T min) {
            this.min = min;
        }

        public void setMax(T max) {
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$min = this.getMin();
            T other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            T this$max = this.getMax();
            T other$max = other.getMax();
            return !(this$max == null ? other$max != null : !this$max.equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            T $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            return result;
        }

        public String toString() {
            return "EasyRandomParameters.Range(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }
}

