/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class ShortRangeRandomizer
extends AbstractRangeRandomizer<Short> {
    public ShortRangeRandomizer(Short min, Short max) {
        super(min, max);
    }

    public ShortRangeRandomizer(Short min, Short max, long seed) {
        super(min, max, seed);
    }

    public static ShortRangeRandomizer aNewShortRangeRandomizer(Short min, Short max) {
        return new ShortRangeRandomizer(min, max);
    }

    public static ShortRangeRandomizer aNewShortRangeRandomizer(Short min, Short max, long seed) {
        return new ShortRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if ((Short)this.min > (Short)this.max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
    }

    @Override
    public Short getRandomValue() {
        return (short)this.nextDouble(((Short)this.min).shortValue(), ((Short)this.max).shortValue());
    }

    @Override
    protected Short getDefaultMaxValue() {
        return (short)Short.MAX_VALUE;
    }

    @Override
    protected Short getDefaultMinValue() {
        return (short)Short.MIN_VALUE;
    }
}

