/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.time;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.time.LocalDateRandomizer;
import org.jeasy.random.randomizers.time.LocalTimeRandomizer;
import org.jeasy.random.randomizers.time.ZoneOffsetRandomizer;

public class OffsetDateTimeRandomizer
implements Randomizer<OffsetDateTime> {
    private LocalDateRandomizer localDateRandomizer;
    private LocalTimeRandomizer localTimeRandomizer;
    private ZoneOffsetRandomizer zoneOffsetRandomizer;

    public OffsetDateTimeRandomizer() {
        this.localDateRandomizer = new LocalDateRandomizer();
        this.localTimeRandomizer = new LocalTimeRandomizer();
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer();
    }

    public OffsetDateTimeRandomizer(long seed) {
        this.localDateRandomizer = new LocalDateRandomizer(seed);
        this.localTimeRandomizer = new LocalTimeRandomizer(seed);
        this.zoneOffsetRandomizer = new ZoneOffsetRandomizer(seed);
    }

    public static OffsetDateTimeRandomizer aNewOffsetDateTimeRandomizer() {
        return new OffsetDateTimeRandomizer();
    }

    public static OffsetDateTimeRandomizer aNewOffsetDateTimeRandomizer(long seed) {
        return new OffsetDateTimeRandomizer(seed);
    }

    @Override
    public OffsetDateTime getRandomValue() {
        LocalDate randomLocalDate = this.localDateRandomizer.getRandomValue();
        LocalTime randomLocalTime = this.localTimeRandomizer.getRandomValue();
        ZoneOffset randomZoneOffset = this.zoneOffsetRandomizer.getRandomValue();
        return OffsetDateTime.of(randomLocalDate, randomLocalTime, randomZoneOffset);
    }

    public void setLocalDateRandomizer(LocalDateRandomizer localDateRandomizer) {
        this.localDateRandomizer = localDateRandomizer;
    }

    public void setLocalTimeRandomizer(LocalTimeRandomizer localTimeRandomizer) {
        this.localTimeRandomizer = localTimeRandomizer;
    }

    public void setZoneOffsetRandomizer(ZoneOffsetRandomizer zoneOffsetRandomizer) {
        this.zoneOffsetRandomizer = zoneOffsetRandomizer;
    }
}

