/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.ExpressionSupport;

public class CompositeExpression
extends ExpressionSupport {
    private List expressions;

    public CompositeExpression() {
        this.expressions = new ArrayList();
    }

    public CompositeExpression(List expressions) {
        this.expressions = expressions;
    }

    public String toString() {
        return super.toString() + "[expressions=" + this.expressions + "]";
    }

    public static Expression parse(String text, ExpressionFactory factory) throws JellyException {
        int len = text.length();
        int startIndex = text.indexOf("${");
        if (startIndex < 0) {
            return new ConstantExpression(text);
        }
        int endIndex = text.indexOf("}", startIndex + 2);
        if (endIndex < 0) {
            throw new JellyException("Missing '}' character at the end of expression: " + text);
        }
        if (startIndex == 0 && endIndex == len - 1) {
            return factory.createExpression(text.substring(2, endIndex));
        }
        CompositeExpression answer = new CompositeExpression();
        int cur = 0;
        char c = '\u0000';
        StringBuffer chars = new StringBuffer();
        StringBuffer expr = new StringBuffer();
        block20: while (cur < len) {
            c = text.charAt(cur);
            block0 : switch (c) {
                case '$': {
                    if (cur + 1 < len) {
                        c = text.charAt(++cur);
                        switch (c) {
                            case '$': {
                                chars.append(c);
                                break;
                            }
                            case '{': {
                                if (chars.length() > 0) {
                                    answer.addTextExpression(chars.toString());
                                    chars.delete(0, chars.length());
                                }
                                if (cur + 1 >= len) break block0;
                                ++cur;
                                block21: while (cur < len) {
                                    c = text.charAt(cur);
                                    switch (c) {
                                        case '\"': {
                                            expr.append(c);
                                            ++cur;
                                            block22: while (cur < len) {
                                                c = text.charAt(cur);
                                                switch (c) {
                                                    case '\\': {
                                                        ++cur;
                                                        expr.append(c);
                                                        continue block22;
                                                    }
                                                    case '\"': {
                                                        ++cur;
                                                        expr.append(c);
                                                        continue block21;
                                                    }
                                                }
                                                ++cur;
                                                expr.append(c);
                                            }
                                            continue block21;
                                        }
                                        case '\'': {
                                            expr.append(c);
                                            ++cur;
                                            block23: while (cur < len) {
                                                c = text.charAt(cur);
                                                switch (c) {
                                                    case '\\': {
                                                        ++cur;
                                                        expr.append(c);
                                                        continue block23;
                                                    }
                                                    case '\'': {
                                                        ++cur;
                                                        expr.append(c);
                                                        continue block21;
                                                    }
                                                }
                                                ++cur;
                                                expr.append(c);
                                            }
                                            continue block21;
                                        }
                                        case '}': {
                                            answer.addExpression(factory.createExpression(expr.toString()));
                                            expr.delete(0, expr.length());
                                            ++cur;
                                            continue block20;
                                        }
                                    }
                                    expr.append(c);
                                    ++cur;
                                }
                                break block0;
                            }
                            default: {
                                chars.append(c);
                                break;
                            }
                        }
                        break;
                    }
                    chars.append(c);
                    break;
                }
                default: {
                    chars.append(c);
                }
            }
            ++cur;
        }
        if (chars.length() > 0) {
            answer.addTextExpression(chars.toString());
        }
        return answer;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List expressions) {
        this.expressions = expressions;
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public void addTextExpression(String text) {
        this.addExpression(new ConstantExpression(text));
    }

    @Override
    public String getExpressionText() {
        StringBuffer buffer = new StringBuffer();
        for (Expression expression : this.expressions) {
            buffer.append(expression.getExpressionText());
        }
        return buffer.toString();
    }

    @Override
    public Object evaluate(JellyContext context) {
        return this.evaluateAsString(context);
    }

    @Override
    public String evaluateAsString(JellyContext context) {
        StringBuffer buffer = new StringBuffer();
        for (Expression expression : this.expressions) {
            String value = expression.evaluateAsString(context);
            if (value == null) continue;
            buffer.append(value);
        }
        return buffer.toString();
    }

    @Override
    public Iterator evaluateAsIterator(JellyContext context) {
        String value = this.evaluateAsString(context);
        if (value == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new SingletonIterator((Object)value);
    }
}

