/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSRecord.class.getName());
    private int _ttl;
    private long _created;
    private InetAddress _source;
    public static final byte[] EMPTY_TXT = new byte[]{0};

    DNSRecord(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl) {
        super(name, type, recordClass, unique);
        this._ttl = ttl;
        this._created = System.currentTimeMillis();
    }

    public boolean equals(Object other) {
        return other instanceof DNSRecord && super.equals(other) && this.sameValue((DNSRecord)other);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord other) {
        return this.getRecordType() == other.getRecordType();
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    abstract DNSOutgoing addAnswer(JmDNSImpl var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming msg) {
        try {
            for (DNSRecord dNSRecord : msg.getAllAnswers()) {
                if (!this.suppressedBy(dNSRecord)) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "suppressedBy() message " + msg + " exception ", e);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord other) {
        return this.equals(other) && other._ttl > this._ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this._created + (long)(percent * this._ttl) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    public boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    void resetTTL(DNSRecord other) {
        this._created = other._created;
        this._ttl = other._ttl;
    }

    void setWillExpireSoon(long now) {
        this._created = now;
        this._ttl = 1;
    }

    abstract void write(DNSOutgoing.MessageOutputStream var1);

    public abstract boolean isSingleValued();

    public ServiceInfo getServiceInfo() {
        return this.getServiceInfo(false);
    }

    public abstract ServiceInfo getServiceInfo(boolean var1);

    public abstract ServiceEvent getServiceEvent(JmDNSImpl var1);

    public void setRecordSource(InetAddress source) {
        this._source = source;
    }

    public InetAddress getRecordSource() {
        return this._source;
    }

    protected void toString(StringBuilder aLog) {
        super.toString(aLog);
        aLog.append(" ttl: '" + this.getRemainingTTL(System.currentTimeMillis()) + "/" + this._ttl + "'");
    }

    public void setTTL(int ttl) {
        this._ttl = ttl;
    }

    public int getTTL() {
        return this._ttl;
    }

    public static class HostInformation
    extends DNSRecord {
        String _os;
        String _cpu;

        public HostInformation(String name, DNSRecordClass recordClass, boolean unique, int ttl, String cpu, String os) {
            super(name, DNSRecordType.TYPE_HINFO, recordClass, unique, ttl);
            this._cpu = cpu;
            this._os = os;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        boolean sameValue(DNSRecord other) {
            HostInformation hinfo = (HostInformation)other;
            return this._cpu.equals(hinfo._cpu) && this._os.equals(hinfo._os);
        }

        public boolean isSingleValued() {
            return true;
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            String hostInfo = this._cpu + " " + this._os;
            out.writeUTF(hostInfo, 0, hostInfo.length());
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            HashMap<String, String> hinfo = new HashMap<String, String>(2);
            hinfo.put("cpu", this._cpu);
            hinfo.put("os", this._os);
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, hinfo);
        }

        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        protected void toString(StringBuilder aLog) {
            super.toString(aLog);
            aLog.append(" cpu: '" + this._cpu + "' os: '" + this._os + "'");
        }
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Service.class.getName());
        private final int _priority;
        private final int _weight;
        private final int _port;
        private final String _server;

        public Service(String name, DNSRecordClass recordClass, boolean unique, int ttl, int priority, int weight, int port, String server) {
            super(name, DNSRecordType.TYPE_SRV, recordClass, unique, ttl);
            this._priority = priority;
            this._weight = weight;
            this._port = port;
            this._server = server;
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeShort(this._priority);
            out.writeShort(this._weight);
            out.writeShort(this._port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                out.writeName(this._server);
            } else {
                out.writeUTF(this._server, 0, this._server.length());
                out.writeByte(0);
            }
        }

        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            dout.writeShort(this._priority);
            dout.writeShort(this._weight);
            dout.writeShort(this._port);
            try {
                dout.write(this._server.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        String getServer() {
            return this._server;
        }

        public int getPriority() {
            return this._priority;
        }

        public int getWeight() {
            return this._weight;
        }

        public int getPort() {
            return this._port;
        }

        boolean sameValue(DNSRecord other) {
            Service s = (Service)other;
            return this._priority == s._priority && this._weight == s._weight && this._port == s._port && this._server.equals(s._server);
        }

        public boolean isSingleValued() {
            return true;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (!(info == null || !info.isAnnouncing() && !info.isAnnounced() || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.finer("handleQuery() Conflicting probe detected from: " + this.getRecordSource());
                Service localService = new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName());
                try {
                    if (dns.getInterface().equals(this.getRecordSource())) {
                        logger1.warning("Got conflicting probe from ourselves\nincoming: " + this.toString() + "\n" + "local   : " + localService.toString());
                    }
                }
                catch (IOException e) {
                    logger1.log(Level.WARNING, "IOException", e);
                }
                int comparison = this.compareTo(localService);
                if (comparison == 0) {
                    logger1.finer("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!info.isProbing() || comparison <= 0) {
                    return false;
                }
                String oldName = info.getQualifiedName().toLowerCase();
                info.setName(dns.incrementName(info.getName()));
                dns.getServices().remove(oldName);
                dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                logger1.finer("handleQuery() Lost tie break: new unique name chosen:" + info.getName());
                info.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (!(info == null || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.finer("handleResponse() Denial detected");
                if (info.isProbing()) {
                    String oldName = info.getQualifiedName().toLowerCase();
                    info.setName(dns.incrementName(info.getName()));
                    dns.getServices().remove(oldName);
                    dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                    logger1.finer("handleResponse() New unique name chose:" + info.getName());
                }
                info.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (info != null && this._port == info.getPort() != this._server.equals(dns.getLocalHost().getName())) {
                return dns.addAnswer(in, addr, port, out, new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName()));
            }
            return out;
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, persistent, this._server);
        }

        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        protected void toString(StringBuilder aLog) {
            super.toString(aLog);
            aLog.append(" server: '" + this._server + ":" + this._port + "'");
        }
    }

    public static class Text
    extends DNSRecord {
        private final byte[] _text;

        public Text(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] text) {
            super(name, DNSRecordType.TYPE_TXT, recordClass, unique, ttl);
            this._text = text != null && text.length > 0 ? text : EMPTY_TXT;
        }

        byte[] getText() {
            return this._text;
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeBytes(this._text, 0, this._text.length);
        }

        boolean sameValue(DNSRecord other) {
            Text txt = (Text)other;
            if (txt._text.length != this._text.length) {
                return false;
            }
            int i = this._text.length;
            while (i-- > 0) {
                if (txt._text[i] == this._text[i]) continue;
                return false;
            }
            return true;
        }

        public boolean isSingleValued() {
            return true;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, this._text);
        }

        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        protected void toString(StringBuilder aLog) {
            super.toString(aLog);
            aLog.append(" text: '" + (this._text.length > 20 ? new String(this._text, 0, 17) + "..." : new String(this._text)) + "'");
        }
    }

    public static class Pointer
    extends DNSRecord {
        private final String _alias;

        public Pointer(String name, DNSRecordClass recordClass, boolean unique, int ttl, String alias) {
            super(name, DNSRecordType.TYPE_PTR, recordClass, unique, ttl);
            this._alias = alias;
        }

        public boolean isSameEntry(DNSEntry entry) {
            return super.isSameEntry(entry) && entry instanceof Pointer && this.sameValue((Pointer)entry);
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeName(this._alias);
        }

        boolean sameValue(DNSRecord other) {
            return this._alias.equals(((Pointer)other)._alias);
        }

        public boolean isSingleValued() {
            return false;
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        String getAlias() {
            return this._alias;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            if (this.isServicesDiscoveryMetaQuery()) {
                Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
                return new ServiceInfoImpl(map, 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isReverseLookup()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isDomainDiscoveryQuery()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
            map.put(ServiceInfo.Fields.Subtype, this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Subtype));
            return new ServiceInfoImpl(map, 0, 0, 0, persistent, this.getAlias());
        }

        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            String domainName = info.getType();
            String serviceName = JmDNSImpl.toUnqualifiedName(domainName, this.getAlias());
            return new ServiceEventImpl(dns, domainName, serviceName, info);
        }

        protected void toString(StringBuilder aLog) {
            super.toString(aLog);
            aLog.append(" alias: '" + (this._alias != null ? this._alias.toString() : "null") + "'");
        }
    }

    public static abstract class Address
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Address.class.getName());
        InetAddress _addr;

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, type, recordClass, unique, ttl);
            this._addr = addr;
        }

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, type, recordClass, unique, ttl);
            try {
                this._addr = InetAddress.getByAddress(rawAddress);
            }
            catch (UnknownHostException exception) {
                logger1.log(Level.WARNING, "Address() exception ", exception);
            }
        }

        boolean same(DNSRecord other) {
            return this.sameName(other) && this.sameValue(other);
        }

        boolean sameName(DNSRecord other) {
            return this.getName().equalsIgnoreCase(((Address)other).getName());
        }

        boolean sameValue(DNSRecord other) {
            return this.getAddress().equals(((Address)other).getAddress());
        }

        public boolean isSingleValued() {
            return false;
        }

        InetAddress getAddress() {
            return this._addr;
        }

        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            byte[] buffer = this.getAddress().getAddress();
            for (int i = 0; i < buffer.length; ++i) {
                dout.writeByte(buffer[i]);
            }
        }

        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), this.isUnique(), 3600);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger1.finer("handleQuery() Conflicting probe detected. lex compare " + this.compareTo(dnsAddress));
                if (dns.isProbing() && this.compareTo(dnsAddress) >= 0) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfo serviceInfo : dns.getServices().values()) {
                        ServiceInfoImpl info = (ServiceInfoImpl)serviceInfo;
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl dns) {
            Address dnsAddress = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), this.isUnique(), 3600);
            if (dnsAddress != null && dnsAddress.sameType(this) && dnsAddress.sameName(this) && !dnsAddress.sameValue(this)) {
                logger1.finer("handleResponse() Denial detected");
                if (dns.isProbing()) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfo serviceInfo : dns.getServices().values()) {
                        ServiceInfoImpl info = (ServiceInfoImpl)serviceInfo;
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            return info;
        }

        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        protected void toString(StringBuilder aLog) {
            super.toString(aLog);
            aLog.append(" address: '" + (this.getAddress() != null ? this.getAddress().getHostAddress() : "null") + "'");
        }
    }

    public static class IPv6Address
    extends Address {
        IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, addr);
        }

        IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, rawAddress);
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            if (this._addr != null) {
                byte[] buffer = this._addr.getAddress();
                if (this._addr instanceof Inet4Address) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
                    }
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = (ServiceInfoImpl)super.getServiceInfo(persistent);
            info.addAddress((Inet6Address)this._addr);
            return info;
        }
    }

    public static class IPv4Address
    extends Address {
        IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, addr);
        }

        IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, rawAddress);
        }

        void write(DNSOutgoing.MessageOutputStream out) {
            if (this._addr != null) {
                byte[] buffer = this._addr.getAddress();
                if (!(this._addr instanceof Inet4Address)) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[4];
                    System.arraycopy(tempbuffer, 12, buffer, 0, 4);
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = (ServiceInfoImpl)super.getServiceInfo(persistent);
            info.addAddress((Inet4Address)this._addr);
            return info;
        }
    }
}

