/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.state.DNSStateTask;

public class Announcer
extends DNSStateTask {
    static Logger logger = Logger.getLogger(Announcer.class.getName());

    public Announcer(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl, Announcer.defaultTTL());
        this.setTaskState(DNSState.ANNOUNCING_1);
        this.associate(DNSState.ANNOUNCING_1);
    }

    public String getName() {
        return "Announcer(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    public String toString() {
        return super.toString() + " state: " + (Object)((Object)this.getTaskState());
    }

    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    public String getTaskDescription() {
        return "announcing";
    }

    protected boolean checkRunCondition() {
        return !this.getDns().isCanceling() && !this.getDns().isCanceled();
    }

    protected DNSOutgoing createOugoing() {
        return new DNSOutgoing(33792);
    }

    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        for (DNSRecord answer : this.getDns().getLocalHost().answers(true, this.getTTL())) {
            newOut = this.addAnswer(newOut, null, answer);
        }
        return newOut;
    }

    protected DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl info, DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        for (DNSRecord answer : info.answers(true, this.getTTL(), this.getDns().getLocalHost())) {
            newOut = this.addAnswer(newOut, null, answer);
        }
        return newOut;
    }

    protected void recoverTask(Throwable e) {
        this.getDns().recover();
    }

    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isAnnouncing()) {
            this.cancel();
            this.getDns().startRenewer();
        }
    }
}

