/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.forward;

import io.jenkins.cli.shaded.org.apache.sshd.client.future.OpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.StreamingChannel;
import io.jenkins.cli.shaded.org.apache.sshd.common.forward.TcpipClientChannel;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.Readable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocksProxy
extends AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map<IoSession, Proxy> proxies = new ConcurrentHashMap<IoSession, Proxy>();

    public SocksProxy(ConnectionService service) {
        this.service = service;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed: " + this.state);
        }
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        Proxy proxy = this.proxies.remove(session);
        if (proxy != null) {
            proxy.close();
        }
    }

    @Override
    public void messageReceived(IoSession session, Readable message) throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        Proxy proxy = this.proxies.get(session);
        if (proxy == null) {
            int version = buffer.getUByte();
            if (version == 4) {
                proxy = new Socks4(session);
            } else if (version == 5) {
                proxy = new Socks5(session);
            } else {
                throw new IllegalStateException("Unsupported version: " + version);
            }
            proxy.onMessage(buffer);
            this.proxies.put(session, proxy);
        } else {
            proxy.onMessage(buffer);
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.log.warn("Exception caught, closing socks proxy", cause);
        session.close(false);
    }

    public static abstract class Proxy
    implements Closeable {
        protected IoSession session;
        protected TcpipClientChannel channel;

        protected Proxy(IoSession session) {
            this.session = session;
        }

        protected void onMessage(Buffer buffer) throws IOException {
            this.session.suspendRead();
            ThreadUtils.runAsInternal(this.channel.getAsyncIn(), out -> out.writeBuffer(buffer).addListener(f -> this.session.resumeRead()));
        }

        @Override
        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close(false);
            }
        }

        protected int getUByte(Buffer buffer) {
            return buffer.getUByte();
        }

        protected int getUShort(Buffer buffer) {
            return (this.getUByte(buffer) << 8) + this.getUByte(buffer);
        }
    }

    public class Socks4
    extends Proxy {
        public Socks4(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            if (this.channel == null) {
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int port = this.getUShort(buffer);
                String host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                String userId = this.getNTString(buffer);
                if (host.startsWith("0.0.0.")) {
                    host = this.getNTString(buffer);
                }
                if (SocksProxy.this.log.isDebugEnabled()) {
                    SocksProxy.this.log.debug("Received socks4 connection request for {} to {}:{}", userId, host, port);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(this::onChannelOpened);
            } else {
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            this.session.resumeRead();
            ByteArrayBuffer buffer = new ByteArrayBuffer(64, false);
            ((Buffer)buffer).putByte((byte)0);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                ((Buffer)buffer).putByte((byte)91);
            } else {
                ((Buffer)buffer).putByte((byte)90);
            }
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            try {
                this.session.writeBuffer(buffer);
            }
            catch (IOException e) {
                SocksProxy.this.log.error("Failed ({}) to send channel open packet for {}: {}", e.getClass().getSimpleName(), this.channel, e.getMessage());
                throw new IllegalStateException("Failed to send packet", e);
            }
        }

        protected String getNTString(Buffer buffer) {
            StringBuilder sb = new StringBuilder();
            char c = (char)this.getUByte(buffer);
            while (c != '\u0000') {
                sb.append(c);
                c = (char)this.getUByte(buffer);
            }
            return sb.toString();
        }
    }

    public class Socks5
    extends Proxy {
        private byte[] authMethods;
        private Buffer response;

        public Socks5(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            boolean debugEnabled = SocksProxy.this.log.isDebugEnabled();
            if (this.authMethods == null) {
                int nbAuthMethods = this.getUByte(buffer);
                this.authMethods = new byte[nbAuthMethods];
                buffer.getRawBytes(this.authMethods);
                boolean foundNoAuth = false;
                for (int i = 0; i < nbAuthMethods; ++i) {
                    foundNoAuth |= this.authMethods[i] == 0;
                }
                buffer = new ByteArrayBuffer(8, false);
                buffer.putByte((byte)5);
                buffer.putByte((byte)(foundNoAuth ? 0 : 255));
                this.session.writeBuffer(buffer);
                if (!foundNoAuth) {
                    throw new IllegalStateException("Received socks5 greeting without NoAuth method");
                }
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 greeting");
                }
            } else if (this.channel == null) {
                String host;
                int type;
                this.response = buffer;
                int version = this.getUByte(buffer);
                if (version != 5) {
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int res = buffer.getUByte();
                if (res != 0 && debugEnabled) {
                    SocksProxy.this.log.debug("No zero reserved value: {}", (Object)res);
                }
                if ((type = buffer.getUByte()) == 1) {
                    host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                } else if (type == 3) {
                    host = this.getBLString(buffer);
                } else if (type == 4) {
                    host = Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer));
                } else {
                    throw new IllegalStateException("Unsupported address type: " + type);
                }
                int port = this.getUShort(buffer);
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection request to {}:{}", (Object)host, (Object)port);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                this.channel.setStreaming(StreamingChannel.Streaming.Async);
                this.session.suspendRead();
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(this::onChannelOpened);
            } else {
                if (debugEnabled) {
                    SocksProxy.this.log.debug("Received socks5 connection message");
                }
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            this.session.resumeRead();
            int wpos = this.response.wpos();
            this.response.rpos(0);
            this.response.wpos(1);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(true);
                this.response.putByte((byte)1);
            } else {
                this.response.putByte((byte)0);
            }
            this.response.wpos(wpos);
            try {
                this.session.writeBuffer(this.response);
            }
            catch (IOException e) {
                SocksProxy.this.log.error("Failed ({}) to send channel open response for {}: {}", e.getClass().getSimpleName(), this.channel, e.getMessage());
                throw new IllegalStateException("Failed to send packet", e);
            }
        }

        protected String getBLString(Buffer buffer) {
            int length = this.getUByte(buffer);
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append((char)this.getUByte(buffer));
            }
            return sb.toString();
        }
    }
}

