/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.ExpressionFactory2;
import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.Main;
import hudson.Messages;
import hudson.TcpSlaveAgentListener;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotatorFactory;
import hudson.init.InitMilestone;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.PageDecorator;
import hudson.model.PaneStatusProperties;
import hudson.model.ParameterDefinition;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.search.SearchableModelObject;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalSecurityConfiguration;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.captcha.CaptchaSupport;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.UserAvatarResolver;
import hudson.util.Area;
import hudson.util.FormValidation;
import hudson.util.Iterators;
import hudson.util.Secret;
import hudson.util.jna.GNUCLibrary;
import hudson.views.MyViewsTabBar;
import hudson.views.ViewsTabBar;
import hudson.widgets.RenderOnDemandClosure;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jexl.parser.ASTSizeFunction;
import org.apache.commons.jexl.util.Introspector;
import org.apache.commons.jexl.util.introspection.Uberspect;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSet;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.jelly.InternationalizedStringExpression;

public class Functions {
    private static final AtomicLong iota = new AtomicLong();
    private static final Pattern ICON_SIZE = Pattern.compile("\\d+x\\d+");
    public static boolean DEBUG_YUI = Boolean.getBoolean("debug.YUI");
    private static final SimpleFormatter formatter = new SimpleFormatter();
    private static String footerURL = null;
    private static final Pattern LINE_END = Pattern.compile("\r?\n");

    public String generateId() {
        return "id" + iota.getAndIncrement();
    }

    public static boolean isModel(Object o) {
        return o instanceof ModelObject;
    }

    public static boolean isModelWithContextMenu(Object o) {
        return o instanceof ModelObjectWithContextMenu;
    }

    public static boolean isModelWithChildren(Object o) {
        return o instanceof ModelObjectWithChildren;
    }

    @Deprecated
    public static boolean isMatrixProject(Object o) {
        return o != null && o.getClass().getName().equals("hudson.matrix.MatrixProject");
    }

    public static String xsDate(Calendar cal) {
        return Util.XS_DATETIME_FORMATTER.format(cal.getTime());
    }

    public static String rfc822Date(Calendar cal) {
        return Util.RFC822_DATETIME_FORMATTER.format(cal.getTime());
    }

    public static boolean isExtensionsAvailable() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins != null && jenkins.getInitLevel().compareTo(InitMilestone.EXTENSIONS_AUGMENTED) >= 0;
    }

    public static void initPageVariables(JellyContext context) {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        String rootURL = currentRequest.getContextPath();
        Functions h = new Functions();
        context.setVariable("h", (Object)h);
        context.setVariable("rootURL", (Object)rootURL);
        context.setVariable("resURL", (Object)(rootURL + Functions.getResourcePath()));
        context.setVariable("imagesURL", (Object)(rootURL + Functions.getResourcePath() + "/images"));
        context.setVariable("userAgent", (Object)currentRequest.getHeader("User-Agent"));
        IconSet.initPageVariables((JellyContext)context);
    }

    public static <B> Class getTypeParameter(Class<? extends B> c, Class<B> base, int n) {
        Type parameterization = Types.getBaseClass(c, base);
        if (parameterization instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)parameterization;
            return Types.erasure((Type)Types.getTypeArgument((Type)pt, (int)n));
        }
        throw new AssertionError((Object)(c + " doesn't properly parameterize " + base));
    }

    public JDK.DescriptorImpl getJDKDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(JDK.DescriptorImpl.class);
    }

    public static String getDiffString(int i) {
        if (i == 0) {
            return "\u00b10";
        }
        String s = Integer.toString(i);
        if (i > 0) {
            return "+" + s;
        }
        return s;
    }

    public static String getDiffString2(int i) {
        if (i == 0) {
            return "";
        }
        String s = Integer.toString(i);
        if (i > 0) {
            return "+" + s;
        }
        return s;
    }

    public static String getDiffString2(String prefix, int i, String suffix) {
        if (i == 0) {
            return "";
        }
        String s = Integer.toString(i);
        if (i > 0) {
            return prefix + "+" + s + suffix;
        }
        return prefix + s + suffix;
    }

    public static String addSuffix(int n, String singular, String plural) {
        StringBuilder buf = new StringBuilder();
        buf.append(n).append(' ');
        if (n == 1) {
            buf.append(singular);
        } else {
            buf.append(plural);
        }
        return buf.toString();
    }

    public static RunUrl decompose(StaplerRequest req) {
        List ancestors = req.getAncestors();
        Ancestor f = null;
        Ancestor l = null;
        for (Ancestor anc : ancestors) {
            if (!(anc.getObject() instanceof Run)) continue;
            if (f == null) {
                f = anc;
            }
            l = anc;
        }
        if (l == null) {
            return null;
        }
        String head = f.getPrev().getUrl() + '/';
        String base = l.getUrl();
        String reqUri = req.getOriginalRequestURI();
        String furl = f.getUrl();
        int slashCount = 0;
        int i = furl.indexOf(47);
        while (i >= 0) {
            ++slashCount;
            i = furl.indexOf(47, i + 1);
        }
        String rest = reqUri.replaceFirst("(?:/+[^/]*){" + slashCount + "}", "");
        return new RunUrl((Run)f.getObject(), head, base, rest);
    }

    public static Area getScreenResolution() {
        Cookie res = Functions.getCookie((HttpServletRequest)Stapler.getCurrentRequest(), "screenResolution");
        if (res != null) {
            return Area.parse(res.getValue());
        }
        return null;
    }

    public static Node.Mode[] getNodeModes() {
        return Node.Mode.values();
    }

    public static String getProjectListString(List<AbstractProject> projects) {
        return Items.toNameList(projects);
    }

    @Deprecated
    public static Object ifThenElse(boolean cond, Object thenValue, Object elseValue) {
        return cond ? thenValue : elseValue;
    }

    public static String appendIfNotNull(String text, String suffix, String nullText) {
        return text == null ? nullText : text + suffix;
    }

    public static Map getSystemProperties() {
        return new TreeMap<Object, Object>(System.getProperties());
    }

    public static Map getEnvVars() {
        return new TreeMap<String, String>(EnvVars.masterEnvVars);
    }

    public static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    public static boolean isGlibcSupported() {
        try {
            GNUCLibrary.LIBC.getpid();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static List<LogRecord> getLogRecords() {
        return Jenkins.logRecords;
    }

    public static String printLogRecord(LogRecord r) {
        return formatter.format(r);
    }

    @Restricted(value={NoExternalUse.class})
    public static String[] printLogRecordHtml(LogRecord r, LogRecord prior) {
        String[] oldParts = prior == null ? new String[4] : Functions.logRecordPreformat(prior);
        String[] newParts = Functions.logRecordPreformat(r);
        for (int i = 0; i < 3; ++i) {
            newParts[i] = "<span class='" + (newParts[i].equals(oldParts[i]) ? "logrecord-metadata-old" : "logrecord-metadata-new") + "'>" + newParts[i] + "</span>";
        }
        newParts[3] = Util.xmlEscape(newParts[3]);
        return newParts;
    }

    private static String[] logRecordPreformat(LogRecord r) {
        String source = r.getSourceClassName() == null ? r.getLoggerName() : (r.getSourceMethodName() == null ? r.getSourceClassName() : r.getSourceClassName() + " " + r.getSourceMethodName());
        String message = new SimpleFormatter().formatMessage(r) + "\n";
        Throwable x = r.getThrown();
        return new String[]{String.format("%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp", new Date(r.getMillis())), source, r.getLevel().getLocalizedName(), x == null ? message : message + Functions.printThrowable(x) + "\n"};
    }

    public static <T> Iterable<T> reverse(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.reverse(list);
        return list;
    }

    public static Cookie getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookie(HttpServletRequest req, String name, String defaultValue) {
        Cookie c = Functions.getCookie(req, name);
        if (c == null || c.getValue() == null) {
            return defaultValue;
        }
        return c.getValue();
    }

    @Restricted(value={NoExternalUse.class})
    public static String validateIconSize(String iconSize) throws SecurityException {
        if (!ICON_SIZE.matcher(iconSize).matches()) {
            throw new SecurityException("invalid iconSize");
        }
        return iconSize;
    }

    public static String getYuiSuffix() {
        return DEBUG_YUI ? "debug" : "min";
    }

    public static <V> SortedMap<Integer, V> filter(SortedMap<Integer, V> map, String from, String to) {
        if (from == null && to == null) {
            return map;
        }
        if (to == null) {
            return map.headMap(Integer.parseInt(from) - 1);
        }
        if (from == null) {
            return map.tailMap(Integer.parseInt(to));
        }
        return map.subMap(Integer.parseInt(to), Integer.parseInt(from) - 1);
    }

    @Restricted(value={NoExternalUse.class})
    public static <V> SortedMap<Integer, V> filterExcludingFrom(SortedMap<Integer, V> map, String from, String to) {
        if (from == null && to == null) {
            return map;
        }
        if (to == null) {
            return map.headMap(Integer.parseInt(from));
        }
        if (from == null) {
            return map.tailMap(Integer.parseInt(to));
        }
        return map.subMap(Integer.parseInt(to), Integer.parseInt(from));
    }

    public static void configureAutoRefresh(HttpServletRequest request, HttpServletResponse response, boolean noAutoRefresh) {
        if (noAutoRefresh) {
            return;
        }
        String param = request.getParameter("auto_refresh");
        boolean refresh = Functions.isAutoRefresh(request);
        if (param != null) {
            refresh = Boolean.parseBoolean(param);
            Cookie c = new Cookie("hudson_auto_refresh", Boolean.toString(refresh));
            c.setPath("/");
            c.setMaxAge(2592000);
            response.addCookie(c);
        }
        if (refresh) {
            response.addHeader("Refresh", System.getProperty("hudson.Functions.autoRefreshSeconds", "10"));
        }
    }

    public static boolean isAutoRefresh(HttpServletRequest request) {
        String param = request.getParameter("auto_refresh");
        if (param != null) {
            return Boolean.parseBoolean(param);
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return false;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals("hudson_auto_refresh")) continue;
            return Boolean.parseBoolean(c.getValue());
        }
        return false;
    }

    public static boolean isCollapsed(String paneId) {
        return PaneStatusProperties.forCurrentUser().isCollapsed(paneId);
    }

    public static String getNearestAncestorUrl(StaplerRequest req, Object it) {
        List list = req.getAncestors();
        for (int i = list.size() - 1; i >= 0; --i) {
            Ancestor anc = (Ancestor)list.get(i);
            if (anc.getObject() != it) continue;
            return anc.getUrl();
        }
        return null;
    }

    public static String getSearchURL() {
        List list = Stapler.getCurrentRequest().getAncestors();
        for (int i = list.size() - 1; i >= 0; --i) {
            Ancestor anc = (Ancestor)list.get(i);
            if (!(anc.getObject() instanceof SearchableModelObject)) continue;
            return anc.getUrl() + "/search/";
        }
        return null;
    }

    public static String appendSpaceIfNotNull(String n) {
        if (n == null) {
            return null;
        }
        return n + ' ';
    }

    public static String nbspIndent(String size) {
        int i = size.indexOf(120);
        i = Integer.parseInt(i > 0 ? size.substring(0, i) : size) / 10;
        StringBuilder buf = new StringBuilder(30);
        for (int j = 0; j < i; ++j) {
            buf.append("&nbsp;");
        }
        return buf.toString();
    }

    public static String getWin32ErrorMessage(IOException e) {
        return Util.getWin32ErrorMessage(e);
    }

    public static boolean isMultiline(String s) {
        if (s == null) {
            return false;
        }
        return s.indexOf(13) >= 0 || s.indexOf(10) >= 0;
    }

    public static String encode(String s) {
        return Util.encode(s);
    }

    public static String escape(String s) {
        return Util.escape(s);
    }

    public static String xmlEscape(String s) {
        return Util.xmlEscape(s);
    }

    public static String xmlUnescape(String s) {
        return s.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&");
    }

    public static String htmlAttributeEscape(String text) {
        StringBuilder buf = new StringBuilder(text.length() + 64);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                buf.append("&#39;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void checkPermission(Permission permission) throws IOException, ServletException {
        Functions.checkPermission(Jenkins.getInstance(), permission);
    }

    public static void checkPermission(AccessControlled object, Permission permission) throws IOException, ServletException {
        if (permission != null) {
            object.checkPermission(permission);
        }
    }

    public static void checkPermission(Object object, Permission permission) throws IOException, ServletException {
        if (permission == null) {
            return;
        }
        if (object instanceof AccessControlled) {
            Functions.checkPermission((AccessControlled)object, permission);
        } else {
            List ancs = Stapler.getCurrentRequest().getAncestors();
            for (Ancestor anc : Iterators.reverse(ancs)) {
                Object o = anc.getObject();
                if (!(o instanceof AccessControlled)) continue;
                Functions.checkPermission((AccessControlled)o, permission);
                return;
            }
            Functions.checkPermission(Jenkins.getInstance(), permission);
        }
    }

    public static boolean hasPermission(Permission permission) throws IOException, ServletException {
        return Functions.hasPermission(Jenkins.getInstance(), permission);
    }

    public static boolean hasPermission(Object object, Permission permission) throws IOException, ServletException {
        if (permission == null) {
            return true;
        }
        if (object instanceof AccessControlled) {
            return ((AccessControlled)object).hasPermission(permission);
        }
        List ancs = Stapler.getCurrentRequest().getAncestors();
        for (Ancestor anc : Iterators.reverse(ancs)) {
            Object o = anc.getObject();
            if (!(o instanceof AccessControlled)) continue;
            return ((AccessControlled)o).hasPermission(permission);
        }
        return Jenkins.getInstance().hasPermission(permission);
    }

    public static void adminCheck(StaplerRequest req, StaplerResponse rsp, Object required, Permission permission) throws IOException, ServletException {
        if (required != null && !Hudson.adminCheck(req, rsp)) {
            rsp.setStatus(403);
            rsp.getOutputStream().close();
            throw new ServletException("Unauthorized access");
        }
        if (permission != null) {
            Functions.checkPermission(permission);
        }
    }

    public static String inferHudsonURL(StaplerRequest req) {
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl != null) {
            return rootUrl;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(req.getScheme()).append("://");
        buf.append(req.getServerName());
        if (!(req.getScheme().equals("http") && req.getLocalPort() == 80 || req.getScheme().equals("https") && req.getLocalPort() == 443)) {
            buf.append(':').append(req.getLocalPort());
        }
        buf.append(req.getContextPath()).append('/');
        return buf.toString();
    }

    public static String getFooterURL() {
        if (footerURL == null && StringUtils.isBlank((String)(footerURL = System.getProperty("hudson.footerURL")))) {
            footerURL = "http://jenkins-ci.org/";
        }
        return footerURL;
    }

    public static List<JobPropertyDescriptor> getJobPropertyDescriptors(Class<? extends Job> clazz) {
        return JobPropertyDescriptor.getPropertyDescriptors(clazz);
    }

    public static List<JobPropertyDescriptor> getJobPropertyDescriptors(Job job) {
        return DescriptorVisibilityFilter.apply(job, JobPropertyDescriptor.getPropertyDescriptors(job.getClass()));
    }

    public static List<Descriptor<BuildWrapper>> getBuildWrapperDescriptors(AbstractProject<?, ?> project) {
        return BuildWrappers.getFor(project);
    }

    public static List<Descriptor<SecurityRealm>> getSecurityRealmDescriptors() {
        return SecurityRealm.all();
    }

    public static List<Descriptor<AuthorizationStrategy>> getAuthorizationStrategyDescriptors() {
        return AuthorizationStrategy.all();
    }

    public static List<Descriptor<Builder>> getBuilderDescriptors(AbstractProject<?, ?> project) {
        return BuildStepDescriptor.filter(Builder.all(), project.getClass());
    }

    public static List<Descriptor<Publisher>> getPublisherDescriptors(AbstractProject<?, ?> project) {
        return BuildStepDescriptor.filter(Publisher.all(), project.getClass());
    }

    public static List<SCMDescriptor<?>> getSCMDescriptors(AbstractProject<?, ?> project) {
        return SCM._for(project);
    }

    public static List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
        return Jenkins.getInstance().getDescriptorList(ComputerLauncher.class);
    }

    public static List<Descriptor<RetentionStrategy<?>>> getRetentionStrategyDescriptors() {
        return RetentionStrategy.all();
    }

    public static List<ParameterDefinition.ParameterDescriptor> getParameterDescriptors() {
        return ParameterDefinition.all();
    }

    public static List<Descriptor<CaptchaSupport>> getCaptchaSupportDescriptors() {
        return CaptchaSupport.all();
    }

    public static List<Descriptor<ViewsTabBar>> getViewsTabBarDescriptors() {
        return ViewsTabBar.all();
    }

    public static List<Descriptor<MyViewsTabBar>> getMyViewsTabBarDescriptors() {
        return MyViewsTabBar.all();
    }

    public static List<NodePropertyDescriptor> getNodePropertyDescriptors(Class<? extends Node> clazz) {
        ArrayList<NodePropertyDescriptor> result = new ArrayList<NodePropertyDescriptor>();
        DescriptorExtensionList list = Jenkins.getInstance().getDescriptorList(NodeProperty.class);
        for (NodePropertyDescriptor npd : list) {
            if (!npd.isApplicable(clazz)) continue;
            result.add(npd);
        }
        return result;
    }

    public static List<NodePropertyDescriptor> getGlobalNodePropertyDescriptors() {
        ArrayList<NodePropertyDescriptor> result = new ArrayList<NodePropertyDescriptor>();
        DescriptorExtensionList list = Jenkins.getInstance().getDescriptorList(NodeProperty.class);
        for (NodePropertyDescriptor npd : list) {
            if (!npd.isApplicableAsGlobal()) continue;
            result.add(npd);
        }
        return result;
    }

    public static Collection<Descriptor> getSortedDescriptorsForGlobalConfig(Predicate<GlobalConfigurationCategory> predicate) {
        ExtensionList<Descriptor> exts = ExtensionList.lookup(Descriptor.class);
        ArrayList<Tag> r = new ArrayList<Tag>(exts.size());
        for (ExtensionComponent<Descriptor> c : exts.getComponents()) {
            Descriptor descriptor = c.getInstance();
            if (descriptor.getGlobalConfigPage() == null) continue;
            if (descriptor instanceof GlobalConfiguration) {
                if (!predicate.apply((Object)((GlobalConfiguration)descriptor).getCategory())) continue;
                r.add(new Tag(c.ordinal(), descriptor));
                continue;
            }
            if (!predicate.apply((Object)GlobalConfigurationCategory.get(GlobalConfigurationCategory.Unclassified.class))) continue;
            r.add(new Tag(0.0, descriptor));
        }
        Collections.sort(r);
        ArrayList<Descriptor> answer = new ArrayList<Descriptor>(r.size());
        for (Tag tag : r) {
            answer.add(tag.d);
        }
        return DescriptorVisibilityFilter.apply(Jenkins.getInstance(), answer);
    }

    public static Collection<Descriptor> getSortedDescriptorsForGlobalConfig() {
        return Functions.getSortedDescriptorsForGlobalConfig((Predicate<GlobalConfigurationCategory>)Predicates.alwaysTrue());
    }

    @Deprecated
    public static Collection<Descriptor> getSortedDescriptorsForGlobalConfigNoSecurity() {
        return Functions.getSortedDescriptorsForGlobalConfig((Predicate<GlobalConfigurationCategory>)Predicates.not(GlobalSecurityConfiguration.FILTER));
    }

    public static Collection<Descriptor> getSortedDescriptorsForGlobalConfigUnclassified() {
        return Functions.getSortedDescriptorsForGlobalConfig(new Predicate<GlobalConfigurationCategory>(){

            public boolean apply(GlobalConfigurationCategory cat) {
                return cat instanceof GlobalConfigurationCategory.Unclassified;
            }
        });
    }

    public static String getIconFilePath(Action a) {
        String name = a.getIconFileName();
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return "images/24x24/" + name;
    }

    public static int size2(Object o) throws Exception {
        if (o == null) {
            return 0;
        }
        return ASTSizeFunction.sizeOf((Object)o, (Uberspect)Introspector.getUberspect());
    }

    public static String getRelativeLinkTo(Item p) {
        HashMap<Object, String> ancestors = new HashMap<Object, String>();
        View view = null;
        StaplerRequest request = Stapler.getCurrentRequest();
        for (Ancestor a : request.getAncestors()) {
            ancestors.put(a.getObject(), a.getRelativePath());
            if (!(a.getObject() instanceof View)) continue;
            view = (View)a.getObject();
        }
        String path = (String)ancestors.get(p);
        if (path != null) {
            return Functions.normalizeURI(path + '/');
        }
        Item i = p;
        String url = "";
        while (true) {
            ItemGroup<? extends Item> ig = i.getParent();
            url = i.getShortUrl() + url;
            if (ig == Jenkins.getInstance() || view != null && ig == view.getOwnerItemGroup()) {
                assert (i instanceof TopLevelItem);
                if (view != null) {
                    return Functions.normalizeURI((String)ancestors.get(view) + '/' + url);
                }
                return Functions.normalizeURI(request.getContextPath() + '/' + p.getUrl());
            }
            path = (String)ancestors.get(ig);
            if (path != null) {
                return Functions.normalizeURI(path + '/' + url);
            }
            assert (ig instanceof Item);
            i = (Item)((Object)ig);
        }
    }

    private static String normalizeURI(String uri) {
        return URI.create(uri).normalize().toString();
    }

    public static List<TopLevelItem> getAllTopLevelItems(ItemGroup root) {
        return Items.getAllItems(root, TopLevelItem.class);
    }

    public static String getRelativeNameFrom(Item p, ItemGroup g, boolean useDisplayName) {
        if (p == null) {
            return null;
        }
        if (g == null) {
            return useDisplayName ? p.getFullDisplayName() : p.getFullName();
        }
        String separationString = useDisplayName ? " \u00bb " : "/";
        HashMap<ItemGroup<? extends Item>, Integer> parents = new HashMap<ItemGroup<? extends Item>, Integer>();
        int depth = 0;
        while (g != null) {
            parents.put(g, depth++);
            if (g instanceof Item) {
                g = ((Item)((Object)g)).getParent();
                continue;
            }
            g = null;
        }
        StringBuilder buf = new StringBuilder();
        Item i = p;
        while (true) {
            if (buf.length() > 0) {
                buf.insert(0, separationString);
            }
            buf.insert(0, useDisplayName ? i.getDisplayName() : i.getName());
            ItemGroup<? extends Item> gr = i.getParent();
            Integer d = (Integer)parents.get(gr);
            if (d != null) {
                for (int j = d.intValue(); j > 0; --j) {
                    buf.insert(0, separationString);
                    buf.insert(0, "..");
                }
                return buf.toString();
            }
            if (!(gr instanceof Item)) break;
            i = (Item)((Object)gr);
        }
        return null;
    }

    public static String getRelativeNameFrom(Item p, ItemGroup g) {
        return Functions.getRelativeNameFrom(p, g, false);
    }

    public static String getRelativeDisplayNameFrom(Item p, ItemGroup g) {
        return Functions.getRelativeNameFrom(p, g, true);
    }

    public static Map<Thread, StackTraceElement[]> dumpAllThreads() {
        TreeMap<Thread, StackTraceElement[]> sorted = new TreeMap<Thread, StackTraceElement[]>(new ThreadSorter());
        sorted.putAll(Thread.getAllStackTraces());
        return sorted;
    }

    public static ThreadInfo[] getThreadInfos() {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        return mbean.dumpAllThreads(mbean.isObjectMonitorUsageSupported(), mbean.isSynchronizerUsageSupported());
    }

    public static ThreadGroupMap sortThreadsAndGetGroupMap(ThreadInfo[] list) {
        ThreadGroupMap sorter = new ThreadGroupMap();
        Arrays.sort(list, sorter);
        return sorter;
    }

    @Deprecated
    public static boolean isMustangOrAbove() {
        return true;
    }

    public static String dumpThreadInfo(ThreadInfo ti, ThreadGroupMap map) {
        String grp = map.getThreadGroup(ti);
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " Group=" + (grp != null ? grp : "?") + " " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = ti.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste);
            sb.append('\n');
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : ti.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(mi);
                sb.append('\n');
            }
        }
        LockInfo[] locks = ti.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ").append(li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static <T> Collection<T> emptyList() {
        return Collections.emptyList();
    }

    public static String jsStringEscape(String s) {
        StringBuilder buf = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    buf.append("\\'");
                    continue block5;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String getVersion() {
        return Jenkins.VERSION;
    }

    public static String getResourcePath() {
        return Jenkins.RESOURCE_PATH;
    }

    public static String getViewResource(Object it, String path) {
        Class clazz = it.getClass();
        if (it instanceof Class) {
            clazz = (Class)it;
        }
        if (it instanceof Descriptor) {
            clazz = ((Descriptor)it).clazz;
        }
        StringBuilder buf = new StringBuilder(Stapler.getCurrentRequest().getContextPath());
        buf.append(Jenkins.VIEW_RESOURCE_PATH).append('/');
        buf.append(clazz.getName().replace('.', '/').replace('$', '/'));
        buf.append('/').append(path);
        return buf.toString();
    }

    public static boolean hasView(Object it, String path) throws IOException {
        if (it == null) {
            return false;
        }
        return Stapler.getCurrentRequest().getView(it, path) != null;
    }

    public static boolean defaultToTrue(Boolean b) {
        if (b == null) {
            return true;
        }
        return b;
    }

    public static <T> T defaulted(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static String printThrowable(@CheckForNull Throwable t) {
        if (t == null) {
            return Messages.Functions_NoExceptionDetails();
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static int determineRows(String s) {
        if (s == null) {
            return 5;
        }
        return Math.max(5, LINE_END.split(s).length);
    }

    public static String toCCStatus(Item i) {
        if (i instanceof Job) {
            Job j = (Job)i;
            switch (j.getIconColor()) {
                case ABORTED: 
                case ABORTED_ANIME: 
                case RED: 
                case RED_ANIME: 
                case YELLOW: 
                case YELLOW_ANIME: {
                    return "Failure";
                }
                case BLUE: 
                case BLUE_ANIME: {
                    return "Success";
                }
                case DISABLED: 
                case DISABLED_ANIME: 
                case GREY: 
                case GREY_ANIME: 
                case NOTBUILT: 
                case NOTBUILT_ANIME: {
                    return "Unknown";
                }
            }
        }
        return "Unknown";
    }

    public static boolean isAnonymous() {
        return Jenkins.getAuthentication() instanceof AnonymousAuthenticationToken;
    }

    public static JellyContext getCurrentJellyContext() {
        JellyContext context = ExpressionFactory2.CURRENT_CONTEXT.get();
        assert (context != null);
        return context;
    }

    public static String runScript(Script script) throws JellyTagException {
        StringWriter out = new StringWriter();
        script.run(Functions.getCurrentJellyContext(), XMLOutput.createXMLOutput((Writer)out));
        return out.toString();
    }

    public static <T> List<T> subList(List<T> base, int maxSize) {
        if (maxSize < base.size()) {
            return base.subList(0, maxSize);
        }
        return base;
    }

    public static String joinPath(String ... components) {
        StringBuilder buf = new StringBuilder();
        for (String s : components) {
            if (s.length() == 0) continue;
            if (buf.length() > 0) {
                if (buf.charAt(buf.length() - 1) != '/') {
                    buf.append('/');
                }
                if (s.charAt(0) == '/') {
                    s = s.substring(1);
                }
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String getActionUrl(String itUrl, Action action) {
        String urlName = action.getUrlName();
        if (urlName == null) {
            return null;
        }
        try {
            if (new URI(urlName).isAbsolute()) {
                return urlName;
            }
        }
        catch (URISyntaxException x) {
            Logger.getLogger(Functions.class.getName()).log(Level.WARNING, "Failed to parse URL for {0}: {1}", new Object[]{action, x});
            return null;
        }
        if (urlName.startsWith("/")) {
            return Functions.joinPath(Stapler.getCurrentRequest().getContextPath(), urlName);
        }
        return Functions.joinPath(Stapler.getCurrentRequest().getContextPath() + '/' + itUrl, urlName);
    }

    public static String toEmailSafeString(String projectName) {
        StringBuilder buf = new StringBuilder(projectName.length());
        for (int i = 0; i < projectName.length(); ++i) {
            char ch = projectName.charAt(i);
            if ('a' <= ch && ch <= 'z' || 'z' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || "-_.".indexOf(ch) >= 0) {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return projectName;
    }

    public String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public String getServerName() {
        String url = Jenkins.getInstance().getRootUrl();
        try {
            String host;
            if (url != null && (host = new URL(url).getHost()) != null) {
                return host;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Stapler.getCurrentRequest().getServerName();
    }

    @Deprecated
    public String getCheckUrl(String userDefined, Object descriptor, String field) {
        if (userDefined != null || field == null) {
            return userDefined;
        }
        if (descriptor instanceof Descriptor) {
            Descriptor d = (Descriptor)descriptor;
            return d.getCheckUrl(field);
        }
        return null;
    }

    public void calcCheckUrl(Map attributes, String userDefined, Object descriptor, String field) {
        if (userDefined != null || field == null) {
            return;
        }
        if (descriptor instanceof Descriptor) {
            Descriptor d = (Descriptor)descriptor;
            FormValidation.CheckMethod m = d.getCheckMethod(field);
            attributes.put("checkUrl", m.toStemUrl());
            attributes.put("checkDependsOn", m.getDependsOn());
        }
    }

    public boolean hyperlinkMatchesCurrentPage(String href) throws UnsupportedEncodingException {
        String url = Stapler.getCurrentRequest().getRequestURL().toString();
        if (href == null || href.length() <= 1) {
            return ".".equals(href) && url.endsWith("/");
        }
        url = URLDecoder.decode(url, "UTF-8");
        href = URLDecoder.decode(href, "UTF-8");
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (href.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        return url.endsWith(href);
    }

    public <T> List<T> singletonList(T t) {
        return Collections.singletonList(t);
    }

    public static List<PageDecorator> getPageDecorators() {
        if (Jenkins.getInstance() == null) {
            return Collections.emptyList();
        }
        return PageDecorator.all();
    }

    public static List<Descriptor<Cloud>> getCloudDescriptors() {
        return Cloud.all();
    }

    public String prepend(String prefix, String body) {
        if (body != null && body.length() > 0) {
            return prefix + body;
        }
        return body;
    }

    public static List<Descriptor<CrumbIssuer>> getCrumbIssuerDescriptors() {
        return CrumbIssuer.all();
    }

    public static String getCrumb(StaplerRequest req) {
        Jenkins h = Jenkins.getInstance();
        CrumbIssuer issuer = h != null ? h.getCrumbIssuer() : null;
        return issuer != null ? issuer.getCrumb((ServletRequest)req) : "";
    }

    public static String getCrumbRequestField() {
        Jenkins h = Jenkins.getInstance();
        CrumbIssuer issuer = h != null ? h.getCrumbIssuer() : null;
        return issuer != null ? ((CrumbIssuerDescriptor)issuer.getDescriptor()).getCrumbRequestField() : "";
    }

    public static Date getCurrentTime() {
        return new Date();
    }

    public static Locale getCurrentLocale() {
        Locale locale = null;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            locale = req.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String generateConsoleAnnotationScriptAndStylesheet() {
        String path;
        String cp = Stapler.getCurrentRequest().getContextPath();
        StringBuilder buf = new StringBuilder();
        for (ConsoleAnnotatorFactory f : ConsoleAnnotatorFactory.all()) {
            path = cp + "/extensionList/" + ConsoleAnnotatorFactory.class.getName() + "/" + f.getClass().getName();
            if (f.hasScript()) {
                buf.append("<script src='").append(path).append("/script.js'></script>");
            }
            if (!f.hasStylesheet()) continue;
            buf.append("<link rel='stylesheet' type='text/css' href='").append(path).append("/style.css' />");
        }
        for (ConsoleAnnotationDescriptor d : ConsoleAnnotationDescriptor.all()) {
            path = cp + "/descriptor/" + d.clazz.getName();
            if (d.hasScript()) {
                buf.append("<script src='").append(path).append("/script.js'></script>");
            }
            if (!d.hasStylesheet()) continue;
            buf.append("<link rel='stylesheet' type='text/css' href='").append(path).append("/style.css' />");
        }
        return buf.toString();
    }

    public List<String> getLoggerNames() {
        while (true) {
            try {
                ArrayList<String> r = new ArrayList<String>();
                Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
                while (e.hasMoreElements()) {
                    r.add(e.nextElement());
                }
                return r;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public String getPasswordValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Secret) {
            return ((Secret)o).getEncryptedValue();
        }
        if (Functions.getIsUnitTest()) {
            throw new SecurityException("attempted to render plaintext \u2018" + o + "\u2019 in password field; use a getter of type Secret instead");
        }
        return o.toString();
    }

    public List filterDescriptors(Object context, Iterable descriptors) {
        return DescriptorVisibilityFilter.apply(context, descriptors);
    }

    public static boolean getIsUnitTest() {
        return Main.isUnitTest;
    }

    public static boolean isArtifactsPermissionEnabled() {
        return Boolean.getBoolean("hudson.security.ArtifactsPermission");
    }

    public static boolean isWipeOutPermissionEnabled() {
        return Boolean.getBoolean("hudson.security.WipeOutPermission");
    }

    public static String createRenderOnDemandProxy(JellyContext context, String attributesToCapture) {
        return Stapler.getCurrentRequest().createJavaScriptProxy((Object)new RenderOnDemandClosure(context, attributesToCapture));
    }

    public static String getCurrentDescriptorByNameUrl() {
        return Descriptor.getCurrentDescriptorByNameUrl();
    }

    public static String setCurrentDescriptorByNameUrl(String value) {
        String o = Functions.getCurrentDescriptorByNameUrl();
        Stapler.getCurrentRequest().setAttribute("currentDescriptorByNameUrl", (Object)value);
        return o;
    }

    public static void restoreCurrentDescriptorByNameUrl(String old) {
        Stapler.getCurrentRequest().setAttribute("currentDescriptorByNameUrl", (Object)old);
    }

    public static List<String> getRequestHeaders(String name) {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration e = Stapler.getCurrentRequest().getHeaders(name);
        while (e.hasMoreElements()) {
            r.add(e.nextElement().toString());
        }
        return r;
    }

    public static Object rawHtml(Object o) {
        return o == null ? null : new InternationalizedStringExpression.RawHtmlArgument(o);
    }

    public static ArrayList<CLICommand> getCLICommands() {
        ArrayList<CLICommand> all = new ArrayList<CLICommand>(CLICommand.all());
        Collections.sort(all, new Comparator<CLICommand>(){

            @Override
            public int compare(CLICommand cliCommand, CLICommand cliCommand1) {
                return cliCommand.getName().compareTo(cliCommand1.getName());
            }
        });
        return all;
    }

    public static String getAvatar(User user, String avatarSize) {
        return UserAvatarResolver.resolve(user, avatarSize);
    }

    @Deprecated
    public String getUserAvatar(User user, String avatarSize) {
        return Functions.getAvatar(user, avatarSize);
    }

    public static String humanReadableByteSize(long size) {
        String measure = "B";
        if (size < 1024L) {
            return size + " " + measure;
        }
        Double number = new Double(size);
        if (number >= 1024.0) {
            number = number / 1024.0;
            measure = "KB";
            if (number >= 1024.0) {
                number = number / 1024.0;
                measure = "MB";
                if (number >= 1024.0) {
                    number = number / 1024.0;
                    measure = "GB";
                }
            }
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        return format.format(number) + " " + measure;
    }

    public static String breakableString(String plain) {
        if (plain == null) {
            return null;
        }
        return plain.replaceAll("([\\p{Punct}&&[^;]]+\\w)", "<wbr>$1").replaceAll("([^\\p{Punct}\\s-]{20})(?=[^\\p{Punct}\\s-]{10})", "$1<wbr>");
    }

    public static void advertiseHeaders(HttpServletResponse rsp) {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            rsp.setHeader("X-Hudson", "1.395");
            rsp.setHeader("X-Jenkins", Jenkins.VERSION);
            rsp.setHeader("X-Jenkins-Session", Jenkins.SESSION_HASH);
            TcpSlaveAgentListener tal = j.tcpSlaveAgentListener;
            if (tal != null) {
                int p = TcpSlaveAgentListener.CLI_PORT != null ? TcpSlaveAgentListener.CLI_PORT.intValue() : tal.getPort();
                rsp.setIntHeader("X-Hudson-CLI-Port", p);
                rsp.setIntHeader("X-Jenkins-CLI-Port", p);
                rsp.setIntHeader("X-Jenkins-CLI2-Port", p);
                rsp.setHeader("X-Jenkins-CLI-Host", TcpSlaveAgentListener.CLI_HOST_NAME);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isContextMenuVisible(Action a) {
        if (a instanceof ModelObjectWithContextMenu.ContextMenuVisibility) {
            return ((ModelObjectWithContextMenu.ContextMenuVisibility)a).isVisible();
        }
        return true;
    }

    private static class ThreadSorter
    extends ThreadSorterBase
    implements Comparator<Thread> {
        private ThreadSorter() {
        }

        @Override
        public int compare(Thread a, Thread b) {
            int result = this.compare(a.getId(), b.getId());
            if (result == 0) {
                result = a.getName().compareToIgnoreCase(b.getName());
            }
            return result;
        }
    }

    public static class ThreadGroupMap
    extends ThreadSorterBase
    implements Comparator<ThreadInfo> {
        public String getThreadGroup(ThreadInfo ti) {
            return (String)this.map.get(ti.getThreadId());
        }

        @Override
        public int compare(ThreadInfo a, ThreadInfo b) {
            int result = this.compare(a.getThreadId(), b.getThreadId());
            if (result == 0) {
                result = a.getThreadName().compareToIgnoreCase(b.getThreadName());
            }
            return result;
        }
    }

    private static class ThreadSorterBase {
        protected Map<Long, String> map = new HashMap<Long, String>();

        private ThreadSorterBase() {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            Thread[] threads = new Thread[tg.activeCount() * 2];
            int threadsLen = tg.enumerate(threads, true);
            for (int i = 0; i < threadsLen; ++i) {
                ThreadGroup group = threads[i].getThreadGroup();
                this.map.put(threads[i].getId(), group != null ? group.getName() : null);
            }
        }

        protected int compare(long idA, long idB) {
            String tgb;
            String tga = this.map.get(idA);
            int result = (tga != null ? -1 : 0) + ((tgb = this.map.get(idB)) != null ? 1 : 0);
            if (result == 0 && tga != null) {
                result = tga.compareToIgnoreCase(tgb);
            }
            return result;
        }
    }

    private static class Tag
    implements Comparable<Tag> {
        double ordinal;
        String hierarchy;
        Descriptor d;

        Tag(double ordinal, Descriptor d) {
            this.ordinal = ordinal;
            this.d = d;
            this.hierarchy = this.buildSuperclassHierarchy(d.clazz, new StringBuilder()).toString();
        }

        private StringBuilder buildSuperclassHierarchy(Class c, StringBuilder buf) {
            Class sc = c.getSuperclass();
            if (sc != null) {
                this.buildSuperclassHierarchy(sc, buf).append(':');
            }
            return buf.append(c.getName());
        }

        @Override
        public int compareTo(Tag that) {
            int r = Double.compare(this.ordinal, that.ordinal);
            if (r != 0) {
                return -r;
            }
            return this.hierarchy.compareTo(that.hierarchy);
        }
    }

    public static final class RunUrl {
        private final String head;
        private final String base;
        private final String rest;
        private final Run run;

        public RunUrl(Run run, String head, String base, String rest) {
            this.run = run;
            this.head = head;
            this.base = base;
            this.rest = rest;
        }

        public String getBaseUrl() {
            return this.base;
        }

        public String getNextBuildUrl() {
            return this.getUrl((Run)this.run.getNextBuild());
        }

        public String getPreviousBuildUrl() {
            return this.getUrl((Run)this.run.getPreviousBuild());
        }

        private String getUrl(Run n) {
            if (n == null) {
                return null;
            }
            return this.head + n.getNumber() + this.rest;
        }
    }
}

