/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.PluginManager;
import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;

public class LocalPluginManager
extends PluginManager {
    private static final Logger LOGGER = Logger.getLogger(LocalPluginManager.class.getName());

    public LocalPluginManager(Jenkins jenkins) {
        super(jenkins.servletContext, new File(jenkins.getRootDir(), "plugins"));
    }

    public LocalPluginManager(File rootDir) {
        super(null, new File(rootDir, "plugins"));
    }

    @Override
    protected Collection<String> loadBundledPlugins() {
        if (System.getProperty("hudson.bundled.plugins") != null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        ServletContext context = Jenkins.getInstance().servletContext;
        for (String path : Util.fixNull(context.getResourcePaths("/WEB-INF/plugins"))) {
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            if (fileName.length() == 0) continue;
            try {
                names.add(fileName);
                URL url = context.getResource(path);
                this.copyBundledPlugin(url, fileName);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + fileName, e);
            }
        }
        return names;
    }
}

