/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import hudson.EnvVars;
import hudson.Proc;
import hudson.Util;
import hudson.util.DualOutputStream;
import hudson.util.EncodingStream;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Main {
    public static boolean isUnitTest = false;
    public static boolean isDevelopmentMode = Boolean.getBoolean(Main.class.getName() + ".development");
    public static final int TIMEOUT = Integer.getInteger(Main.class.getName() + ".timeout", 15000);

    public static void main(String[] args) {
        try {
            System.exit(Main.run(args));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int run(String[] args) throws Exception {
        String home = Main.getHudsonHome();
        if (home == null) {
            System.err.println("JENKINS_HOME is not set.");
            return -1;
        }
        if (args.length < 2) {
            System.err.println("Usage: <job-name> <command> <args..>");
            return -1;
        }
        return Main.remotePost(args);
    }

    private static String getHudsonHome() {
        String home = EnvVars.masterEnvVars.get("JENKINS_HOME");
        if (home != null) {
            return home;
        }
        return EnvVars.masterEnvVars.get("HUDSON_HOME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int remotePost(String[] args) throws Exception {
        String auth;
        String projectName = args[0];
        String home = Main.getHudsonHome();
        if (!home.endsWith("/")) {
            home = home + '/';
        }
        if ((auth = new URL(home).getUserInfo()) != null) {
            auth = "Basic " + new Base64Encoder().encode(auth.getBytes("UTF-8"));
        }
        HttpURLConnection con = Main.open(new URL(home));
        if (auth != null) {
            con.setRequestProperty("Authorization", auth);
        }
        con.connect();
        if (con.getResponseCode() != 200 || con.getHeaderField("X-Hudson") == null) {
            System.err.println(home + " is not Hudson (" + con.getResponseMessage() + ")");
            return -1;
        }
        URL jobURL = new URL(home + "job/" + Util.encode(projectName).replace("/", "/job/") + "/");
        HttpURLConnection con2 = Main.open(new URL(jobURL, "acceptBuildResult"));
        if (auth != null) {
            con2.setRequestProperty("Authorization", auth);
        }
        con2.connect();
        if (con2.getResponseCode() != 200) {
            System.err.println(jobURL + " is not a valid external job (" + con2.getResponseCode() + " " + con2.getResponseMessage() + ")");
            return -1;
        }
        String crumbField = null;
        String crumbValue = null;
        try {
            String line;
            String[] components;
            HttpURLConnection con3 = Main.open(new URL(home + "crumbIssuer/api/xml?xpath=concat(//crumbRequestField,\":\",//crumb)'"));
            if (auth != null) {
                con3.setRequestProperty("Authorization", auth);
            }
            if ((components = (line = IOUtils.readFirstLine(con3.getInputStream(), "UTF-8")).split(":")).length == 2) {
                crumbField = components[0];
                crumbValue = components[1];
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        File tmpFile = File.createTempFile("hudson", "log");
        try {
            int ret;
            FileOutputStream os = new FileOutputStream(tmpFile);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");
            try {
                w.write("<?xml version='1.0' encoding='UTF-8'?>");
                w.write("<run><log encoding='hexBinary' content-encoding='" + Charset.defaultCharset().name() + "'>");
                ((Writer)w).flush();
                long start = System.currentTimeMillis();
                ArrayList<String> cmd = new ArrayList<String>();
                for (int i = 1; i < args.length; ++i) {
                    cmd.add(args[i]);
                }
                Proc.LocalProc proc = new Proc.LocalProc(cmd.toArray(new String[0]), (String[])null, System.in, (OutputStream)new DualOutputStream(System.out, new EncodingStream(os)));
                ret = ((Proc)proc).join();
                w.write("</log><result>" + ret + "</result><duration>" + (System.currentTimeMillis() - start) + "</duration></run>");
            }
            finally {
                IOUtils.closeQuietly(w);
            }
            URL location = new URL(jobURL, "postBuildResult");
            while (true) {
                try {
                    HttpURLConnection con4 = Main.open(location);
                    if (auth != null) {
                        con4.setRequestProperty("Authorization", auth);
                    }
                    if (crumbField != null && crumbValue != null) {
                        con4.setRequestProperty(crumbField, crumbValue);
                    }
                    con4.setDoOutput(true);
                    con4.setFixedLengthStreamingMode((int)tmpFile.length());
                    con4.connect();
                    FileInputStream in = new FileInputStream(tmpFile);
                    try {
                        Util.copyStream(in, con4.getOutputStream());
                    }
                    finally {
                        IOUtils.closeQuietly(in);
                    }
                    if (con4.getResponseCode() != 200) {
                        Util.copyStream(con4.getErrorStream(), System.err);
                    }
                    int n = ret;
                    return n;
                }
                catch (HttpRetryException e) {
                    if (e.getLocation() != null) {
                        location = new URL(e.getLocation());
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    private static HttpURLConnection open(URL url) throws IOException {
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setReadTimeout(TIMEOUT);
        c.setConnectTimeout(TIMEOUT);
        return c;
    }
}

