/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.ImmutableSet;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.Util;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.util.VersionNumber;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class PluginWrapper
implements Comparable<PluginWrapper>,
ModelObject {
    public final PluginManager parent;
    private final Manifest manifest;
    public final ClassLoader classLoader;
    public final URL baseResourceURL;
    private final File disableFile;
    private final File pinFile;
    private final File archive;
    private final String shortName;
    private final boolean active;
    private boolean hasCycleDependency = false;
    private final List<Dependency> dependencies;
    private final List<Dependency> optionalDependencies;
    boolean isBundled;
    private Set<String> dependants = Collections.emptySet();
    private static Set<String> CORE_ONLY_DEPENDANT = ImmutableSet.copyOf(Arrays.asList("jenkins-core"));
    private static final Logger LOGGER = Logger.getLogger(PluginWrapper.class.getName());
    public static final String MANIFEST_FILENAME = "META-INF/MANIFEST.MF";

    public void setDependants(@Nonnull Set<String> dependants) {
        this.dependants = dependants;
    }

    @Nonnull
    public Set<String> getDependants() {
        if (this.isBundled && this.dependants.isEmpty()) {
            return CORE_ONLY_DEPENDANT;
        }
        return this.dependants;
    }

    public boolean hasDependants() {
        return this.isBundled || !this.dependants.isEmpty();
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public PluginWrapper(PluginManager parent, File archive, Manifest manifest, URL baseResourceURL, ClassLoader classLoader, File disableFile, List<Dependency> dependencies, List<Dependency> optionalDependencies) {
        this.parent = parent;
        this.manifest = manifest;
        this.shortName = PluginWrapper.computeShortName(manifest, archive.getName());
        this.baseResourceURL = baseResourceURL;
        this.classLoader = classLoader;
        this.disableFile = disableFile;
        this.pinFile = new File(archive.getPath() + ".pinned");
        this.active = !disableFile.exists();
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        this.archive = archive;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.removeStart((String)this.getLongName(), (String)"Jenkins ");
    }

    public Api getApi() {
        return new Api(this);
    }

    public URL getIndexPage() {
        URL idx = null;
        try {
            Enumeration<URL> en = this.classLoader.getResources("index.jelly");
            while (en.hasMoreElements()) {
                idx = en.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return idx != null && idx.toString().contains(this.shortName) ? idx : null;
    }

    static String computeShortName(Manifest manifest, String fileName) {
        String n = manifest.getMainAttributes().getValue("Short-Name");
        if (n != null) {
            return n;
        }
        n = manifest.getMainAttributes().getValue("Extension-Name");
        if (n != null) {
            return n;
        }
        return FilenameUtils.getBaseName((String)fileName);
    }

    @Exported
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    @Exported
    public String getShortName() {
        return this.shortName;
    }

    @CheckForNull
    public Plugin getPlugin() {
        PluginManager.PluginInstanceStore pis = Jenkins.lookup(PluginManager.PluginInstanceStore.class);
        return pis != null ? pis.store.get(this) : null;
    }

    @Exported
    public String getUrl() {
        String url = this.manifest.getMainAttributes().getValue("Url");
        if (url != null) {
            return url;
        }
        UpdateSite.Plugin ui = this.getInfo();
        if (ui != null) {
            return ui.wiki;
        }
        return null;
    }

    public String toString() {
        return "Plugin:" + this.getShortName();
    }

    @Exported
    public String getLongName() {
        String name = this.manifest.getMainAttributes().getValue("Long-Name");
        if (name != null) {
            return name;
        }
        return this.shortName;
    }

    @Exported
    public YesNoMaybe supportsDynamicLoad() {
        String v = this.manifest.getMainAttributes().getValue("Support-Dynamic-Loading");
        if (v == null) {
            return YesNoMaybe.MAYBE;
        }
        return Boolean.parseBoolean(v) ? YesNoMaybe.YES : YesNoMaybe.NO;
    }

    @Exported
    public String getVersion() {
        return this.getVersionOf(this.manifest);
    }

    private String getVersionOf(Manifest manifest) {
        String v = manifest.getMainAttributes().getValue("Plugin-Version");
        if (v != null) {
            return v;
        }
        v = manifest.getMainAttributes().getValue("Implementation-Version");
        if (v != null) {
            return v;
        }
        return "???";
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.getVersion());
    }

    public boolean isOlderThan(VersionNumber v) {
        try {
            return this.getVersionNumber().compareTo(v) < 0;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public void stop() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            try {
                LOGGER.log(Level.FINE, "Stopping {0}", this.shortName);
                plugin.stop();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to shut down " + this.shortName, t);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not find Plugin instance to stop for {0}", this.shortName);
        }
        LogFactory.release((ClassLoader)this.classLoader);
    }

    public void releaseClassLoader() {
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down classloader", e);
            }
        }
    }

    public void enable() throws IOException {
        if (!this.disableFile.delete()) {
            throw new IOException("Failed to delete " + this.disableFile);
        }
    }

    public void disable() throws IOException {
        FileOutputStream os = new FileOutputStream(this.disableFile);
        ((OutputStream)os).close();
    }

    @Exported
    public boolean isActive() {
        return this.active && !this.hasCycleDependency();
    }

    public boolean hasCycleDependency() {
        return this.hasCycleDependency;
    }

    public void setHasCycleDependency(boolean hasCycle) {
        this.hasCycleDependency = hasCycle;
    }

    @Exported
    public boolean isBundled() {
        return this.isBundled;
    }

    @Exported
    public boolean isEnabled() {
        return !this.disableFile.exists();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setPlugin(Plugin plugin) {
        Jenkins.lookup(PluginManager.PluginInstanceStore.class).store.put(this, plugin);
        plugin.wrapper = this;
    }

    public String getPluginClass() {
        return this.manifest.getMainAttributes().getValue("Plugin-Class");
    }

    public boolean hasLicensesXml() {
        try {
            new URL(this.baseResourceURL, "WEB-INF/licenses.xml").openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void resolvePluginDependencies() throws IOException {
        ArrayList<String> missingDependencies = new ArrayList<String>();
        for (Dependency d : this.dependencies) {
            if (this.parent.getPlugin(d.shortName) != null) continue;
            missingDependencies.add(d.toString());
        }
        if (!missingDependencies.isEmpty()) {
            throw new IOException("Dependency " + Util.join(missingDependencies, ", ") + " doesn't exist");
        }
        for (Dependency d : this.optionalDependencies) {
            if (this.parent.getPlugin(d.shortName) == null) continue;
            this.dependencies.add(d);
        }
    }

    public UpdateSite.Plugin getUpdateInfo() {
        UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
        UpdateSite.Plugin p = uc.getPlugin(this.getShortName());
        if (p != null && p.isNewerThan(this.getVersion())) {
            return p;
        }
        return null;
    }

    public UpdateSite.Plugin getInfo() {
        UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
        return uc.getPlugin(this.getShortName());
    }

    @Exported
    public boolean hasUpdate() {
        return this.getUpdateInfo() != null;
    }

    @Exported
    public boolean isPinned() {
        return this.pinFile.exists();
    }

    @Exported
    public boolean isDeleted() {
        return !this.archive.exists();
    }

    @Override
    public int compareTo(PluginWrapper pw) {
        return this.shortName.compareToIgnoreCase(pw.shortName);
    }

    @Exported
    public boolean isDowngradable() {
        return this.getBackupFile().exists();
    }

    public File getBackupFile() {
        return new File(Jenkins.getInstance().getRootDir(), "plugins/" + this.getShortName() + ".bak");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public String getBackupVersion() {
        File backup = this.getBackupFile();
        if (backup.exists()) {
            String string;
            JarFile backupPlugin = new JarFile(backup);
            try {
                string = backupPlugin.getManifest().getMainAttributes().getValue("Plugin-Version");
            }
            catch (Throwable throwable) {
                try {
                    backupPlugin.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to get backup version from " + backup, e);
                    return null;
                }
            }
            backupPlugin.close();
            return string;
        }
        return null;
    }

    public boolean isPinningForcingOldVersion() {
        if (!this.isPinned()) {
            return false;
        }
        Manifest bundled = Jenkins.getInstance().pluginManager.getBundledPluginManifest(this.getShortName());
        if (bundled == null) {
            return false;
        }
        VersionNumber you = new VersionNumber(this.getVersionOf(bundled));
        VersionNumber me = this.getVersionNumber();
        return me.isOlderThan(you);
    }

    @RequirePOST
    public HttpResponse doMakeEnabled() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.enable();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doMakeDisabled() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.disable();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doPin() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        new FileOutputStream(this.pinFile).close();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doUnpin() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.pinFile.delete();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doDoUninstall() throws IOException {
        Jenkins jenkins = Jenkins.getActiveInstance();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        this.archive.delete();
        jenkins.getPluginManager().resolveDependantPlugins();
        return HttpResponses.redirectViaContextPath((String)"/pluginManager/installed");
    }

    @ExportedBean
    public static final class Dependency {
        @Exported
        public final String shortName;
        @Exported
        public final String version;
        @Exported
        public final boolean optional;

        public Dependency(String s) {
            int idx = s.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Illegal dependency specifier " + s);
            }
            this.shortName = s.substring(0, idx);
            this.version = s.substring(idx + 1);
            boolean isOptional = false;
            String[] osgiProperties = s.split(";");
            for (int i = 1; i < osgiProperties.length; ++i) {
                String osgiProperty = osgiProperties[i].trim();
                if (!osgiProperty.equalsIgnoreCase("resolution:=optional")) continue;
                isOptional = true;
            }
            this.optional = isOptional;
        }

        public String toString() {
            return this.shortName + " (" + this.version + ")";
        }
    }
}

