/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Messages;
import hudson.URLConnectionDecorator;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jvnet.robust_http_client.RetryableHttpStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ProxyConfiguration
extends AbstractDescribableImpl<ProxyConfiguration>
implements Saveable,
Serializable {
    public final String name;
    public final int port;
    private final String userName;
    public final String noProxyHost;
    @Deprecated
    private String password;
    private Secret secretPassword;
    private String testUrl;
    private static final XStream XSTREAM = new XStream2();
    private static final long serialVersionUID = 1L;

    public ProxyConfiguration(String name, int port) {
        this(name, port, null, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password) {
        this(name, port, userName, password, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost) {
        this(name, port, userName, password, noProxyHost, null);
    }

    @DataBoundConstructor
    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost, String testUrl) {
        this.name = Util.fixEmptyAndTrim(name);
        this.port = port;
        this.userName = Util.fixEmptyAndTrim(userName);
        this.secretPassword = Secret.fromString(password);
        this.noProxyHost = Util.fixEmptyAndTrim(noProxyHost);
        this.testUrl = Util.fixEmptyAndTrim(testUrl);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return Secret.toString(this.secretPassword);
    }

    public String getEncryptedPassword() {
        return this.secretPassword == null ? null : this.secretPassword.getEncryptedValue();
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public List<Pattern> getNoProxyHostPatterns() {
        return ProxyConfiguration.getNoProxyHostPatterns(this.noProxyHost);
    }

    public static List<Pattern> getNoProxyHostPatterns(String noProxyHost) {
        if (noProxyHost == null) {
            return Collections.emptyList();
        }
        ArrayList r = Lists.newArrayList();
        for (String s : noProxyHost.split("[ \t\n,|]+")) {
            if (s.length() == 0) continue;
            r.add(Pattern.compile(s.replace(".", "\\.").replace("*", ".*")));
        }
        return r;
    }

    @Deprecated
    public Proxy createProxy() {
        return this.createProxy(null);
    }

    public Proxy createProxy(String host) {
        return ProxyConfiguration.createProxy(host, this.name, this.port, this.noProxyHost);
    }

    public static Proxy createProxy(String host, String name, int port, String noProxyHost) {
        if (host != null && noProxyHost != null) {
            for (Pattern p : ProxyConfiguration.getNoProxyHostPatterns(noProxyHost)) {
                if (!p.matcher(host).matches()) continue;
                return Proxy.NO_PROXY;
            }
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(name, port));
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile config = ProxyConfiguration.getXmlFile();
        config.write(this);
        SaveableListener.fireOnChange(this, config);
    }

    public Object readResolve() {
        if (this.secretPassword == null) {
            this.secretPassword = Secret.fromString(Scrambler.descramble(this.password));
        }
        this.password = null;
        return this;
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.getInstance().getRootDir(), "proxy.xml"));
    }

    public static ProxyConfiguration load() throws IOException {
        XmlFile f = ProxyConfiguration.getXmlFile();
        if (f.exists()) {
            return (ProxyConfiguration)f.read();
        }
        return null;
    }

    public static URLConnection open(URL url) throws IOException {
        ProxyConfiguration p;
        Jenkins h = Jenkins.getInstance();
        ProxyConfiguration proxyConfiguration = p = h != null ? h.proxy : null;
        if (p == null) {
            return url.openConnection();
        }
        URLConnection con = url.openConnection(p.createProxy(url.getHost()));
        if (p.getUserName() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                        return null;
                    }
                    ProxyConfiguration p = Jenkins.getInstance().proxy;
                    return new PasswordAuthentication(p.getUserName(), p.getPassword().toCharArray());
                }
            });
        }
        for (URLConnectionDecorator d : URLConnectionDecorator.all()) {
            d.decorate(con);
        }
        return con;
    }

    public static InputStream getInputStream(URL url) throws IOException {
        ProxyConfiguration p;
        Jenkins h = Jenkins.getInstance();
        ProxyConfiguration proxyConfiguration = p = h != null ? h.proxy : null;
        if (p == null) {
            return new RetryableHttpStream(url);
        }
        RetryableHttpStream is = new RetryableHttpStream(url, p.createProxy(url.getHost()));
        if (p.getUserName() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                        return null;
                    }
                    return new PasswordAuthentication(p.getUserName(), p.getPassword().toCharArray());
                }
            });
        }
        return is;
    }

    static {
        XSTREAM.alias("proxy", ProxyConfiguration.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ProxyConfiguration> {
        @Override
        public String getDisplayName() {
            return "Proxy Configuration";
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            int port;
            if ((value = Util.fixEmptyAndTrim(value)) == null) {
                return FormValidation.ok();
            }
            try {
                port = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error(Messages.PluginManager_PortNotANumber());
            }
            if (port < 0 || port > 65535) {
                return FormValidation.error(Messages.PluginManager_PortNotInRange(0, 65535));
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doValidateProxy(@QueryParameter(value="testUrl") String testUrl, @QueryParameter(value="name") String name, @QueryParameter(value="port") int port, @QueryParameter(value="userName") String userName, @QueryParameter(value="password") String password, @QueryParameter(value="noProxyHost") String noProxyHost) {
            if (Util.fixEmptyAndTrim(testUrl) == null) {
                return FormValidation.error(Messages.ProxyConfiguration_TestUrlRequired());
            }
            GetMethod method = null;
            try {
                int code;
                method = new GetMethod(testUrl);
                method.getParams().setParameter("http.socket.timeout", (Object)new Integer(30000));
                HttpClient client = new HttpClient();
                if (Util.fixEmptyAndTrim(name) != null) {
                    client.getHostConfiguration().setProxy(name, port);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, Secret.fromString(password).getPlainText());
                    AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1);
                    client.getState().setProxyCredentials(scope, (Credentials)credentials);
                }
                if ((code = client.executeMethod((HttpMethod)method)) != 200) {
                    FormValidation formValidation = FormValidation.error(Messages.ProxyConfiguration_FailedToConnect(testUrl, code));
                    return formValidation;
                }
            }
            catch (IOException e) {
                FormValidation formValidation = FormValidation.error(e, Messages.ProxyConfiguration_FailedToConnectViaProxy(testUrl));
                return formValidation;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            return FormValidation.ok(Messages.ProxyConfiguration_Success());
        }
    }
}

