/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.slaves.OfflineCause;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.AgentProtocol;

public final class TcpSlaveAgentListener
extends Thread {
    private final ServerSocketChannel serverSocket;
    private volatile boolean shuttingDown;
    public final int configuredPort;
    private static int iotaGen = 1;
    private static final Logger LOGGER = Logger.getLogger(TcpSlaveAgentListener.class.getName());
    public static String CLI_HOST_NAME = System.getProperty(TcpSlaveAgentListener.class.getName() + ".hostName");
    public static Integer CLI_PORT = Integer.getInteger(TcpSlaveAgentListener.class.getName() + ".port");

    public TcpSlaveAgentListener(int port) throws IOException {
        super("TCP slave agent listener port=" + port);
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.socket().bind(new InetSocketAddress(port));
        }
        catch (BindException e) {
            throw (BindException)new BindException("Failed to listen on port " + port + " because it's already in use.").initCause(e);
        }
        this.configuredPort = port;
        LOGGER.log(Level.FINE, "JNLP slave agent listener started on TCP port {0}", this.getPort());
        this.start();
    }

    public int getPort() {
        return this.serverSocket.socket().getLocalPort();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket s = this.serverSocket.accept().socket();
                s.setKeepAlive(true);
                s.setTcpNoDelay(true);
                new ConnectionHandler(s).start();
            }
        }
        catch (IOException e) {
            if (!this.shuttingDown) {
                LOGGER.log(Level.SEVERE, "Failed to accept JNLP slave agent connections", e);
            }
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close down TCP port", e);
        }
    }

    public static class ConnectionFromCurrentPeer
    extends OfflineCause {
        public String toString() {
            return "The current peer is reconnecting";
        }
    }

    private final class ConnectionHandler
    extends Thread {
        private final Socket s;
        private final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionHandler(Socket s) {
            this.s = s;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.id = iotaGen++;
            }
            this.setName("TCP slave agent connection handler #" + this.id + " with " + s.getRemoteSocketAddress());
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Accepted connection #" + this.id + " from " + this.s.getRemoteSocketAddress());
                DataInputStream in = new DataInputStream(this.s.getInputStream());
                PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream(), "UTF-8")), true);
                String s = in.readUTF();
                if (s.startsWith("Protocol:")) {
                    String protocol = s.substring(9);
                    AgentProtocol p = AgentProtocol.of(protocol);
                    if (p != null) {
                        p.handle(this.s);
                    } else {
                        this.error(out, "Unknown protocol:" + s);
                    }
                } else {
                    this.error(out, "Unrecognized protocol: " + s);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Connection #" + this.id + " aborted", e);
                try {
                    this.s.close();
                }
                catch (IOException _) {}
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Connection #" + this.id + " failed", e);
                try {
                    this.s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void error(PrintWriter out, String msg) throws IOException {
            out.println(msg);
            LOGGER.log(Level.WARNING, "Connection #" + this.id + " is aborted: " + msg);
            this.s.close();
        }
    }
}

