/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.TcpSlaveAgentListener;
import hudson.UDPBroadcastFragment;
import hudson.model.Hudson;
import hudson.util.OneShotEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class UDPBroadcastThread
extends Thread {
    private final Jenkins jenkins;
    public final OneShotEvent ready = new OneShotEvent();
    private MulticastSocket mcs;
    private boolean shutdown;
    static boolean udpHandlingProblem;
    public static final int PORT;
    private static final Logger LOGGER;
    public static InetAddress MULTICAST;

    @Deprecated
    public UDPBroadcastThread(Hudson jenkins) throws IOException {
        this((Jenkins)jenkins);
    }

    public UDPBroadcastThread(Jenkins jenkins) throws IOException {
        super("Jenkins UDP " + PORT + " monitoring thread");
        this.jenkins = jenkins;
        this.mcs = new MulticastSocket(PORT);
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void run() {
        try {
            this.mcs.joinGroup(MULTICAST);
            this.ready.signal();
            while (true) {
                byte[] buf = new byte[2048];
                DatagramPacket p = new DatagramPacket(buf, buf.length);
                this.mcs.receive(p);
                SocketAddress sender = p.getSocketAddress();
                TcpSlaveAgentListener tal = this.jenkins.getTcpSlaveAgentListener();
                StringBuilder rsp = new StringBuilder("<hudson>");
                this.tag(rsp, "version", Jenkins.VERSION);
                this.tag(rsp, "url", this.jenkins.getRootUrl());
                this.tag(rsp, "server-id", this.jenkins.getLegacyInstanceId());
                this.tag(rsp, "slave-port", tal == null ? null : Integer.valueOf(tal.getPort()));
                for (UDPBroadcastFragment f : UDPBroadcastFragment.all()) {
                    f.buildFragment(rsp, sender);
                }
                rsp.append("</hudson>");
                byte[] response = rsp.toString().getBytes("UTF-8");
                this.mcs.send(new DatagramPacket(response, response.length, sender));
            }
        }
        catch (ClosedByInterruptException e) {
        }
        catch (SocketException e) {
            if (this.shutdown) {
                return;
            }
            LOGGER.log(Level.INFO, "Cannot listen to UDP port {0}, skipping: {1}", new Object[]{PORT, e});
            LOGGER.log(Level.FINE, null, e);
        }
        catch (IOException e) {
            if (this.shutdown) {
                return;
            }
            LOGGER.log(Level.WARNING, "UDP handling problem", e);
            udpHandlingProblem = true;
        }
    }

    private void tag(StringBuilder buf, String tag, Object value) {
        if (value == null) {
            return;
        }
        buf.append('<').append(tag).append('>').append(value).append("</").append(tag).append('>');
    }

    public void shutdown() {
        this.shutdown = true;
        this.mcs.close();
        this.interrupt();
    }

    static {
        PORT = Integer.getInteger("hudson.udp", 33848);
        LOGGER = Logger.getLogger(UDPBroadcastThread.class.getName());
        try {
            MULTICAST = InetAddress.getByAddress(new byte[]{-17, 77, 124, -43});
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }
}

