/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliManagerImpl;
import hudson.model.FullDuplexHttpChannel;
import hudson.model.UnprotectedRootAction;
import hudson.remoting.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public class CLIAction
implements UnprotectedRootAction,
StaplerProxy {
    private final transient Map<UUID, FullDuplexHttpChannel> duplexChannels = new HashMap<UUID, FullDuplexHttpChannel>();

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Jenkins CLI";
    }

    @Override
    public String getUrlName() {
        return "cli";
    }

    public void doCommand(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(Jenkins.READ);
        String commandName = req.getRestOfPath().substring(1);
        CLICommand command = CLICommand.clone(commandName);
        if (command == null) {
            rsp.sendError(404, "No such command");
            return;
        }
        req.setAttribute("command", (Object)command);
        req.getView((Object)this, "command.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public Object getTarget() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req.getRestOfPath().length() == 0 && "POST".equals(req.getMethod())) {
            throw new CliEndpointResponse();
        }
        return this;
    }

    private class CliEndpointResponse
    extends HttpResponses.HttpResponseException {
        private CliEndpointResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            block6: {
                try {
                    UUID uuid = UUID.fromString(req.getHeader("Session"));
                    rsp.setHeader("Hudson-Duplex", "");
                    if (req.getHeader("Side").equals("download")) {
                        FullDuplexHttpChannel server = new FullDuplexHttpChannel(uuid, !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)){

                            @Override
                            protected void main(Channel channel) throws IOException, InterruptedException {
                                channel.setProperty(CLICommand.TRANSPORT_AUTHENTICATION, (Object)Jenkins.getAuthentication());
                                channel.setProperty((Object)CliEntryPoint.class.getName(), (Object)new CliManagerImpl(channel));
                            }
                        };
                        CLIAction.this.duplexChannels.put(uuid, server);
                        try {
                            server.download(req, rsp);
                            break block6;
                        }
                        finally {
                            CLIAction.this.duplexChannels.remove(uuid);
                        }
                    }
                    ((FullDuplexHttpChannel)CLIAction.this.duplexChannels.get(uuid)).upload(req, rsp);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

