/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.PermalinkProjectAction;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Extension
public class ConsoleCommand
extends CLICommand {
    @Argument(metaVar="JOB", usage="Name of the job", required=true)
    public AbstractProject<?, ?> job;
    @Argument(metaVar="BUILD", usage="Build number or permalink to point to the build. Defaults to the last build", required=false, index=1)
    public String build = "lastBuild";
    @Option(name="-f", usage="If the build is in progress, stay around and append console output as it comes, like 'tail -f'")
    public boolean follow = false;
    @Option(name="-n", metaVar="N", usage="Display the last N lines")
    public int n = -1;

    @Override
    public String getShortDescription() {
        return Messages.ConsoleCommand_ShortDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int run() throws Exception {
        block13: {
            Run run;
            this.job.checkPermission(Item.BUILD);
            try {
                int n = Integer.parseInt(this.build);
                run = this.job.getBuildByNumber(n);
                if (run == null) {
                    throw new CmdLineException("No such build #" + n);
                }
            }
            catch (NumberFormatException e) {
                PermalinkProjectAction.Permalink p = this.job.getPermalinks().get(this.build);
                if (p != null) {
                    run = (AbstractBuild)p.resolve(this.job);
                    if (run == null) {
                        throw new CmdLineException("Permalink " + this.build + " produced no build");
                    }
                }
                PermalinkProjectAction.Permalink nearest = this.job.getPermalinks().findNearest(this.build);
                throw new CmdLineException(String.format("Not sure what you meant by \"%s\". Did you mean \"%s\"?", this.build, nearest.getId()));
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.stdout, this.getClientCharset());
            try {
                long pos;
                long l = pos = this.n >= 0 ? this.seek((AbstractBuild<?, ?>)run) : 0L;
                if (this.follow) {
                    AnnotatedLargeText logText;
                    do {
                        logText = run.getLogText();
                        pos = logText.writeLogTo(pos, w);
                    } while (!logText.isComplete());
                    break block13;
                }
                try (InputStream logInputStream = run.getLogInputStream();){
                    IOUtils.skip((InputStream)logInputStream, (long)pos);
                    IOUtils.copy((Reader)new InputStreamReader(logInputStream, run.getCharset()), (Writer)w);
                }
            }
            finally {
                w.flush();
                w.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long seek(AbstractBuild<?, ?> run) throws IOException {
        class RingBuffer {
            long[] lastNlines;
            int ptr;

            RingBuffer() {
                this.lastNlines = new long[ConsoleCommand.this.n];
                this.ptr = 0;
                for (int i = 0; i < ConsoleCommand.this.n; ++i) {
                    this.lastNlines[i] = -1L;
                }
            }

            void add(long pos) {
                this.lastNlines[this.ptr] = pos;
                this.ptr = (this.ptr + 1) % this.lastNlines.length;
            }

            long get() {
                long v = this.lastNlines[this.ptr];
                if (v < 0L) {
                    return this.lastNlines[0];
                }
                return v;
            }
        }
        RingBuffer rb = new RingBuffer();
        InputStream in = run.getLogInputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            int prev = 0;
            long pos = 0L;
            boolean prevIsNL = false;
            while ((len = in.read(buf)) >= 0) {
                for (int i = 0; i < len; ++i) {
                    boolean isNL;
                    int ch = buf[i];
                    boolean bl = isNL = ch == 13 || ch == 10;
                    if (!isNL && prevIsNL) {
                        rb.add(pos);
                    }
                    if (isNL && prevIsNL && (prev != 13 || ch != 10)) {
                        rb.add(pos);
                    }
                    ++pos;
                    prev = ch;
                    prevIsNL = isNL;
                }
            }
            long l = rb.get();
            return l;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    protected void printUsageSummary(PrintStream stderr) {
        stderr.println("Produces the console output of a specific build to stdout, as if you are doing 'cat build.log'");
    }
}

