/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Item;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.args4j.Argument;

@Extension
public class CreateJobCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of the job to create", required=true)
    public String name;

    @Override
    public String getShortDescription() {
        return Messages.CreateJobCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins h = Jenkins.getInstance();
        if (h.getItemByFullName(this.name) != null) {
            this.stderr.println("Job '" + this.name + "' already exists");
            return -1;
        }
        ModifiableTopLevelItemGroup ig = h;
        int i = this.name.lastIndexOf(47);
        if (i > 0) {
            String group = this.name.substring(0, i);
            Item item = h.getItemByFullName(group);
            if (item == null) {
                throw new IllegalArgumentException("Unknown ItemGroup " + group);
            }
            if (!(item instanceof ModifiableTopLevelItemGroup)) {
                throw new IllegalArgumentException("Can't create job from CLI in " + group);
            }
            ig = (ModifiableTopLevelItemGroup)((Object)item);
            this.name = this.name.substring(i + 1);
        }
        Jenkins.checkGoodName(this.name);
        ig.createProjectFromXML(this.name, this.stdin);
        return 0;
    }
}

