/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.User;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;

@Extension
public class CreateNodeCommand
extends CLICommand {
    @Argument(metaVar="NODE", usage="Name of the node")
    public String nodeName;

    @Override
    public String getShortDescription() {
        return Messages.CreateNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(Computer.CREATE);
        Node newNode = (Node)Jenkins.XSTREAM2.fromXML(this.stdin);
        if (this.nodeName != null) {
            newNode.setNodeName(this.nodeName);
        }
        if (newNode instanceof Slave) {
            User user = User.current();
            ((Slave)newNode).setUserId(user == null ? "anonymous" : user.getId());
        }
        if (jenkins.getNode(newNode.getNodeName()) != null) {
            throw new CmdLineException(null, "Node '" + newNode.getNodeName() + "' already exists");
        }
        jenkins.addNode(newNode);
        return 0;
    }
}

