/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.AbstractBuildRangeCommand;
import hudson.cli.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

@Extension
public class DeleteBuildsCommand
extends AbstractBuildRangeCommand {
    @Override
    public String getShortDescription() {
        return Messages.DeleteBuildsCommand_ShortDescription();
    }

    @Override
    protected void printUsageSummary(PrintStream stderr) {
        stderr.println("Delete build records of a specified job, possibly in a bulk. ");
    }

    @Override
    protected int act(List<AbstractBuild<?, ?>> builds) throws IOException {
        this.job.checkPermission(Run.DELETE);
        for (AbstractBuild<?, ?> build : builds) {
            build.delete();
        }
        this.stdout.println("Deleted " + builds.size() + " builds");
        return 0;
    }
}

