/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.AbstractItem;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteJobCommand
extends CLICommand {
    @Argument(usage="Name of the job(s) to delete", required=true, multiValued=true)
    private List<String> jobs;
    private static final Logger LOGGER = Logger.getLogger(DeleteJobCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.DeleteJobCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            this.stderr.println("The Jenkins instance has not been started, or was already shut down!");
            return -1;
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.jobs);
        for (String job_s : hs) {
            AbstractItem job = null;
            try {
                job = (AbstractItem)jenkins.getItemByFullName(job_s);
                if (job == null) {
                    this.stderr.format("No such job '%s'\n", job_s);
                    errorOccurred = true;
                    continue;
                }
                try {
                    job.checkPermission(AbstractItem.DELETE);
                }
                catch (Exception e) {
                    this.stderr.println(e.getMessage());
                    errorOccurred = true;
                    continue;
                }
                job.delete();
            }
            catch (Exception e) {
                String errorMsg = String.format("Unexpected exception occurred during deletion of job '%s': %s", job == null ? "(null)" : job.getFullName(), e.getMessage());
                this.stderr.println(errorMsg);
                LOGGER.warning(errorMsg);
                errorOccurred = true;
            }
        }
        return errorOccurred ? -1 : 0;
    }
}

