/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Node;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteNodeCommand
extends CLICommand {
    @Argument(usage="Nodes name to delete", required=true, multiValued=true)
    private List<String> nodes;
    private static final Logger LOGGER = Logger.getLogger(DeleteNodeCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.DeleteNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            this.stderr.println("The Jenkins instance has not been started, or was already shut down!");
            return -1;
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.nodes);
        for (String node_s : hs) {
            Node node = null;
            try {
                node = jenkins.getNode(node_s);
                if (node == null) {
                    this.stderr.format("No such node '%s'\n", node_s);
                    errorOccurred = true;
                    continue;
                }
                node.toComputer().doDoDelete();
            }
            catch (AccessDeniedException e) {
                this.stderr.println(e.getMessage());
                errorOccurred = true;
            }
            catch (Exception e) {
                String errorMsg = String.format("Unexpected exception occurred during deletion of node '%s': %s", node == null ? "(null)" : node.toComputer().getName(), e.getMessage());
                this.stderr.println(errorMsg);
                LOGGER.warning(errorMsg);
                errorOccurred = true;
            }
        }
        return errorOccurred ? -1 : 0;
    }
}

