/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.cli.handlers.ViewOptionHandler;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteViewCommand
extends CLICommand {
    @Argument(usage="View names to delete", required=true, multiValued=true)
    private List<String> views;
    private static final Logger LOGGER = Logger.getLogger(DeleteViewCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.DeleteViewCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.views);
        ViewOptionHandler voh = new ViewOptionHandler(null, null, null);
        for (String view_s : hs) {
            View view = null;
            try {
                try {
                    view = voh.getView(view_s);
                    if (view == null) {
                        this.stderr.println("user is missing the View/Read permission");
                        errorOccurred = true;
                        continue;
                    }
                    view.checkPermission(View.DELETE);
                }
                catch (Exception e) {
                    this.stderr.println(e.getMessage());
                    errorOccurred = true;
                    continue;
                }
                ViewGroup group = view.getOwner();
                if (!group.canDelete(view)) {
                    this.stderr.format("%s does not allow to delete '%s' view\n", group.getDisplayName(), view.getViewName());
                    errorOccurred = true;
                    continue;
                }
                group.deleteView(view);
            }
            catch (Exception e) {
                String errorMsg = String.format("Unexpected exception occurred during deletion of view '%s': %s", view == null ? "(null)" : view.getViewName(), e.getMessage());
                this.stderr.println(errorMsg);
                LOGGER.warning(errorMsg);
                errorOccurred = true;
            }
        }
        return errorOccurred ? -1 : 0;
    }
}

