/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class HelpCommand
extends CLICommand {
    @Argument(metaVar="COMMAND", usage="Name of the command")
    public String command;

    @Override
    public String getShortDescription() {
        return Messages.HelpCommand_ShortDescription();
    }

    @Override
    protected int run() {
        if (!Jenkins.getInstance().hasPermission(Jenkins.READ)) {
            this.stderr.println("You must authenticate to access this Jenkins.\nUse --username/--password/--password-file parameters or login command.");
            return -1;
        }
        if (this.command != null) {
            return this.showCommandDetails();
        }
        this.showAllCommands();
        return 0;
    }

    private int showAllCommands() {
        TreeMap<String, CLICommand> commands = new TreeMap<String, CLICommand>();
        for (CLICommand c : CLICommand.all()) {
            commands.put(c.getName(), c);
        }
        for (CLICommand c : commands.values()) {
            this.stderr.println("  " + c.getName());
            this.stderr.println("    " + c.getShortDescription());
        }
        return 0;
    }

    private int showCommandDetails() {
        CLICommand command = CLICommand.clone(this.command);
        if (command == null) {
            this.stderr.format("No such command %s. Awailable commands are: ", this.command);
            this.showAllCommands();
            return -1;
        }
        command.printUsage(this.stderr, command.getCmdLineParser());
        return 0;
    }
}

