/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.EditDistance;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.kohsuke.args4j.Argument;

@Extension
public class InstallToolCommand
extends CLICommand {
    @Argument(index=0, metaVar="KIND", usage="The type of the tool to install, such as 'Ant'")
    public String toolType;
    @Argument(index=1, metaVar="NAME", usage="The name of the tool to install, as you've entered in the Jenkins system configuration")
    public String toolName;

    @Override
    public String getShortDescription() {
        return Messages.InstallToolCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins h = Jenkins.getInstance();
        h.checkPermission(Jenkins.READ);
        BuildIDs id = (BuildIDs)this.checkChannel().call((Callable)new BuildIDs());
        if (!id.isComplete()) {
            throw new AbortException("This command can be only invoked from a build executing inside Hudson");
        }
        AbstractProject p = Jenkins.getInstance().getItemByFullName(id.job, AbstractProject.class);
        if (p == null) {
            throw new AbortException("No such job found: " + id.job);
        }
        p.checkPermission(Item.CONFIGURE);
        ArrayList<String> toolTypes = new ArrayList<String>();
        for (ToolDescriptor d : ToolInstallation.all()) {
            toolTypes.add(d.getDisplayName());
            if (!d.getDisplayName().equals(this.toolType)) continue;
            ArrayList<String> toolNames = new ArrayList<String>();
            for (ToolInstallation t : d.getInstallations()) {
                toolNames.add(t.getName());
                if (!t.getName().equals(this.toolName)) continue;
                return this.install(t, id, p);
            }
            this.error(toolNames, this.toolName, "name");
        }
        this.error(toolTypes, this.toolType, "type");
        throw new AssertionError();
    }

    private int error(List<String> candidates, String given, String noun) throws AbortException {
        if (given == null) {
            throw new AbortException("No tool " + noun + " was specified. Valid values are " + candidates.toString());
        }
        throw new AbortException("Unrecognized tool " + noun + ". Perhaps you meant '" + EditDistance.findNearest(given, candidates) + "'?");
    }

    private int install(ToolInstallation t, BuildIDs id, AbstractProject p) throws IOException, InterruptedException {
        Run b = p.getBuildByNumber(Integer.parseInt(id.number));
        if (b == null) {
            throw new AbortException("No such build: " + id.number);
        }
        Executor exec = b.getExecutor();
        if (exec == null) {
            throw new AbortException(b.getFullDisplayName() + " is not building");
        }
        Node node = exec.getOwner().getNode();
        if (node == null) {
            throw new AbortException("The node " + exec.getOwner().getDisplayName() + " has been deleted");
        }
        t = t.translate(node, EnvVars.getRemote((VirtualChannel)this.checkChannel()), new StreamTaskListener(this.stderr));
        this.stdout.println(t.getHome());
        return 0;
    }

    private static final class BuildIDs
    extends MasterToSlaveCallable<BuildIDs, IOException> {
        String job;
        String number;
        String id;
        private static final long serialVersionUID = 1L;

        private BuildIDs() {
        }

        public BuildIDs call() throws IOException {
            this.job = System.getenv("JOB_NAME");
            this.number = System.getenv("BUILD_NUMBER");
            this.id = System.getenv("BUILD_ID");
            return this;
        }

        boolean isComplete() {
            return this.job != null && this.number != null && this.id != null;
        }
    }
}

