/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.TopLevelItem;
import hudson.model.View;
import java.util.Collection;
import java.util.Iterator;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.args4j.Argument;

@Extension
public class ListJobsCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of the view", required=false)
    public String name;

    @Override
    public String getShortDescription() {
        return Messages.ListJobsCommand_ShortDescription();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int run() throws Exception {
        Collection<TopLevelItem> jobs;
        Jenkins h = Jenkins.getInstance();
        if (this.name != null) {
            View view = h.getView(this.name);
            if (view != null) {
                jobs = view.getAllItems();
            } else {
                Item item = h.getItemByFullName(this.name);
                if (!(item instanceof ModifiableTopLevelItemGroup)) {
                    this.stderr.println("No view or item group with the given name found");
                    return -1;
                }
                jobs = Items.getAllItems((ModifiableTopLevelItemGroup)((Object)item), TopLevelItem.class);
            }
        } else {
            jobs = h.getItems();
        }
        Iterator i$ = jobs.iterator();
        while (i$.hasNext()) {
            TopLevelItem topLevelItem = (TopLevelItem)i$.next();
            this.stdout.println(topLevelItem.getName());
        }
        return 0;
    }
}

