/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.UpdateSite;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class ListPluginsCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of a specific plugin", required=false)
    public String name;

    @Override
    public String getShortDescription() {
        return Messages.ListPluginsCommand_ShortDescription();
    }

    @Override
    protected int run() {
        Jenkins h = Jenkins.getInstance();
        PluginManager pluginManager = h.getPluginManager();
        if (this.name != null) {
            PluginWrapper plugin = pluginManager.getPlugin(this.name);
            if (plugin != null) {
                this.printPlugin(plugin, plugin.getShortName().length(), plugin.getDisplayName().length());
            } else {
                this.stderr.println(String.format("No plugin with the name '%s' found", this.name));
            }
        } else {
            int colWidthShortName = 1;
            int colWidthDisplayName = 1;
            List<PluginWrapper> plugins = pluginManager.getPlugins();
            if (plugins != null) {
                for (PluginWrapper plugin : plugins) {
                    colWidthShortName = Math.max(colWidthShortName, plugin.getShortName().length());
                    colWidthDisplayName = Math.max(colWidthDisplayName, plugin.getDisplayName().length());
                }
                for (PluginWrapper plugin : plugins) {
                    this.printPlugin(plugin, colWidthShortName, colWidthDisplayName);
                }
            }
        }
        return 0;
    }

    private void printPlugin(PluginWrapper plugin, int colWidthShortName, int colWidthDisplayName) {
        String version;
        if (plugin.hasUpdate()) {
            UpdateSite.Plugin updateInfo = plugin.getUpdateInfo();
            version = String.format("%s (%s)", plugin.getVersion(), updateInfo.version);
        } else {
            version = plugin.getVersion();
        }
        String formatString = String.format("%%-%ds %%-%ds %%s", colWidthShortName, colWidthDisplayName);
        this.stdout.println(String.format(formatString, plugin.getShortName(), plugin.getDisplayName(), version));
    }
}

