/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Computer;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.args4j.Argument;

@Extension
public class OnlineNodeCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Slave name, or empty string for master")
    public String computerName;
    private static final Logger LOGGER = Logger.getLogger(OnlineNodeCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.OnlineNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getInstance();
        Computer computer = jenkins.getComputer(this.computerName);
        if (computer == null) {
            this.stderr.println(hudson.model.Messages.Computer_NoSuchSlaveExists(this.computerName, null));
            errorOccurred = true;
        } else {
            try {
                computer.cliOnline();
            }
            catch (AccessDeniedException e) {
                this.stderr.println(e.getMessage());
                errorOccurred = true;
            }
            catch (Exception e) {
                String errorMsg = String.format("Unexpected exception occurred during performing online operation on node '%s': %s", computer == null ? "(null)" : computer.getName(), e.getMessage());
                this.stderr.println(errorMsg);
                LOGGER.warning(errorMsg);
                errorOccurred = true;
            }
        }
        return errorOccurred ? 1 : 0;
    }
}

