/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.AbstractProject;
import hudson.model.Run;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;

@Extension
public class SetBuildDisplayNameCommand
extends CLICommand
implements Serializable {
    private static final long serialVersionUID = 6665171784136358536L;
    @Argument(metaVar="JOB", usage="Name of the job to build", required=true, index=0)
    public transient AbstractProject<?, ?> job;
    @Argument(metaVar="BUILD#", usage="Number of the build", required=true, index=1)
    public int number;
    @Argument(metaVar="DISPLAYNAME", required=true, usage="DisplayName to be set. '-' to read from stdin.", index=2)
    public String displayName;

    @Override
    public String getShortDescription() {
        return Messages.SetBuildDisplayNameCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Run run = this.job.getBuildByNumber(this.number);
        if (run == null) {
            this.stderr.format("Build #%d does not exist\n", this.number);
            return -1;
        }
        run.checkPermission(Run.UPDATE);
        if ("-".equals(this.displayName)) {
            this.displayName = IOUtils.toString((InputStream)this.stdin);
        }
        run.setDisplayName(this.displayName);
        return 0;
    }
}

