/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.declarative;

import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.cli.CloneableCLICommand;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.cli.declarative.MethodBinder;
import hudson.model.Hudson;
import hudson.security.CliAuthenticator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.args4j.ClassParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

@Extension
public class CLIRegisterer
extends ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(CLIRegisterer.class.getName());

    @Override
    public ExtensionComponentSet refresh() throws ExtensionRefreshException {
        return ExtensionComponentSet.EMPTY;
    }

    @Override
    public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson jenkins) {
        if (type == CLICommand.class) {
            return this.discover(jenkins);
        }
        return Collections.emptyList();
    }

    private Method findResolver(Class type) throws IOException {
        List<Method> resolvers = Util.filter(Index.list(CLIResolver.class, (ClassLoader)Jenkins.getInstance().getPluginManager().uberClassLoader), Method.class);
        while (type != null) {
            for (Method m : resolvers) {
                if (m.getReturnType() != type) continue;
                return m;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private List<ExtensionComponent<CLICommand>> discover(final Jenkins hudson) {
        LOGGER.fine("Listing up @CLIMethod");
        ArrayList<ExtensionComponent<CLICommand>> r = new ArrayList<ExtensionComponent<CLICommand>>();
        try {
            for (final Method m : Util.filter(Index.list(CLIMethod.class, (ClassLoader)hudson.getPluginManager().uberClassLoader), Method.class)) {
                try {
                    final String name = m.getAnnotation(CLIMethod.class).name();
                    final ResourceBundleHolder res = this.loadMessageBundle(m);
                    res.format("CLI." + name + ".shortDescription", new Object[0]);
                    r.add(new ExtensionComponent<1>(new CloneableCLICommand(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getShortDescription() {
                            return res.format("CLI." + name + ".shortDescription", new Object[0]);
                        }

                        @Override
                        protected CmdLineParser getCmdLineParser() {
                            return this.bindMethod(new ArrayList<MethodBinder>());
                        }

                        private CmdLineParser bindMethod(List<MethodBinder> binders) {
                            Stack<Method> chains;
                            CmdLineParser parser;
                            block4: {
                                Class<?> type;
                                this.registerOptionHandlers();
                                parser = new CmdLineParser(null);
                                chains = new Stack<Method>();
                                Method method = m;
                                do {
                                    chains.push(method);
                                    if (Modifier.isStatic(method.getModifiers())) break block4;
                                    type = method.getDeclaringClass();
                                    try {
                                        method = CLIRegisterer.this.findResolver(type);
                                    }
                                    catch (IOException ex) {
                                        throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + type, ex);
                                    }
                                } while (method != null);
                                throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + type);
                            }
                            while (!chains.isEmpty()) {
                                binders.add(new MethodBinder((Method)chains.pop(), this, parser));
                            }
                            return parser;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
                            this.stdout = stdout;
                            this.stderr = stderr;
                            this.locale = locale;
                            ArrayList<MethodBinder> binders = new ArrayList<MethodBinder>();
                            CmdLineParser parser = this.bindMethod(binders);
                            try {
                                SecurityContext sc = SecurityContextHolder.getContext();
                                Authentication old = sc.getAuthentication();
                                try {
                                    CliAuthenticator authenticator = Jenkins.getInstance().getSecurityRealm().createCliAuthenticator(this);
                                    new ClassParser().parse((Object)authenticator, parser);
                                    parser.parseArgument(args);
                                    Authentication auth = authenticator.authenticate();
                                    if (auth == Jenkins.ANONYMOUS) {
                                        auth = this.loadStoredAuthentication();
                                    }
                                    sc.setAuthentication(auth);
                                    hudson.checkPermission(Jenkins.READ);
                                    Object instance = null;
                                    for (MethodBinder binder : binders) {
                                        instance = binder.call(instance);
                                    }
                                    if (instance instanceof Integer) {
                                        int n = (Integer)instance;
                                        return n;
                                    }
                                    int n = 0;
                                    return n;
                                }
                                catch (InvocationTargetException e) {
                                    Throwable t = e.getTargetException();
                                    if (!(t instanceof Exception)) throw e;
                                    throw (Exception)t;
                                }
                                finally {
                                    sc.setAuthentication(old);
                                }
                            }
                            catch (CmdLineException e2) {
                                stderr.println(e2.getMessage());
                                this.printUsage(stderr, parser);
                                return 1;
                            }
                            catch (Exception e3) {
                                e3.printStackTrace(stderr);
                                return 1;
                            }
                        }

                        @Override
                        protected int run() throws Exception {
                            throw new UnsupportedOperationException();
                        }
                    }));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.SEVERE, "Failed to process @CLIMethod: " + m, e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to discvoer @CLIMethod", e);
        }
        return r;
    }

    private ResourceBundleHolder loadMessageBundle(Method m) throws ClassNotFoundException {
        Class<?> c = m.getDeclaringClass();
        Class<?> msg = c.getClassLoader().loadClass(c.getName().substring(0, c.getName().lastIndexOf(".")) + ".Messages");
        return ResourceBundleHolder.get(msg);
    }
}

