/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.handlers;

import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ViewOptionHandler
extends OptionHandler<View> {
    public ViewOptionHandler(CmdLineParser parser, OptionDef option, Setter<View> setter) {
        super(parser, option, setter);
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        this.setter.addValue((Object)this.getView(params.getParameter(0)));
        return 1;
    }

    @CheckForNull
    public View getView(String name) throws CmdLineException {
        ViewGroup group = Jenkins.getInstance();
        View view = null;
        if (group == null) {
            throw new CmdLineException(this.owner, "The Jenkins instance has not been started, or was already shut down!");
        }
        StringTokenizer tok = new StringTokenizer(name, "/");
        while (tok.hasMoreTokens()) {
            String viewName = tok.nextToken();
            view = group.getView(viewName);
            if (view == null) {
                throw new CmdLineException(this.owner, String.format("No view named %s inside view %s", viewName, group.getDisplayName()));
            }
            try {
                view.checkPermission(View.READ);
            }
            catch (Exception e) {
                throw new CmdLineException(this.owner, e.getMessage());
            }
            if (view instanceof ViewGroup) {
                group = (ViewGroup)((Object)view);
                continue;
            }
            if (!tok.hasMoreTokens()) continue;
            throw new CmdLineException(this.owner, view.getViewName() + " view can not contain views");
        }
        return view;
    }

    public String getDefaultMetaVariable() {
        return "VIEW";
    }
}

