/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import java.util.regex.Pattern;

@Extension
public class UrlAnnotator
extends ConsoleAnnotatorFactory<Object> {
    @Override
    public ConsoleAnnotator newInstance(Object context) {
        return new UrlConsoleAnnotator();
    }

    private static class UrlConsoleAnnotator
    extends ConsoleAnnotator {
        private static final long serialVersionUID = 1L;
        private static final Pattern URL = Pattern.compile("\\b(http|https|file|ftp)://[^\\s<>]+[^\\s<>,\\.:\"'()\\[\\]=]");
        private static final String OPEN = "'\"()[]<>";
        private static final String CLOSE = "'\")(][><";

        private UrlConsoleAnnotator() {
        }

        public ConsoleAnnotator annotate(Object context, MarkupText text) {
            for (MarkupText.SubText t : text.findTokens(URL)) {
                int prev = t.start() - 1;
                int ch = prev >= 0 ? (int)text.charAt(prev) : 32;
                int idx = OPEN.indexOf(ch);
                if (idx >= 0) {
                    t = t.subText(0, t.getText().indexOf(CLOSE.charAt(idx)));
                }
                t.href(t.getText());
            }
            return this;
        }
    }
}

