/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import com.google.common.base.Predicate;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.Extension;
import hudson.XmlFile;
import hudson.diagnosis.Messages;
import hudson.model.AbstractItem;
import hudson.model.AdministrativeMonitor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ManagementLink;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.util.RobustReflectionConverter;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class OldDataMonitor
extends AdministrativeMonitor {
    private static final Logger LOGGER = Logger.getLogger(OldDataMonitor.class.getName());
    private ConcurrentMap<SaveableReference, VersionRange> data = new ConcurrentHashMap<SaveableReference, VersionRange>();
    @Extension
    public static final SaveableListener changeListener = new SaveableListener(){

        @Override
        public void onChange(Saveable obj, XmlFile file) {
            OldDataMonitor.remove(obj, false);
        }
    };
    @Extension
    public static final ItemListener itemDeleteListener = new ItemListener(){

        @Override
        public void onDeleted(Item item) {
            OldDataMonitor.remove(item, true);
        }
    };
    @Extension
    public static final RunListener<Run> runDeleteListener = new RunListener<Run>(){

        @Override
        public void onDeleted(Run run) {
            OldDataMonitor.remove(run, true);
        }
    };

    static OldDataMonitor get(Jenkins j) {
        return (OldDataMonitor)j.getAdministrativeMonitor("OldData");
    }

    public OldDataMonitor() {
        super("OldData");
    }

    @Override
    public String getDisplayName() {
        return Messages.OldDataMonitor_DisplayName();
    }

    @Override
    public boolean isActivated() {
        return !this.data.isEmpty();
    }

    public Map<Saveable, VersionRange> getData() {
        HashMap<Saveable, VersionRange> r = new HashMap<Saveable, VersionRange>();
        for (Map.Entry entry : this.data.entrySet()) {
            Saveable s = ((SaveableReference)entry.getKey()).get();
            if (s == null) continue;
            r.put(s, (VersionRange)entry.getValue());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(Saveable obj, boolean isDelete) {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            OldDataMonitor odm = OldDataMonitor.get(j);
            SecurityContext oldContext = ACL.impersonate(ACL.SYSTEM);
            try {
                odm.data.remove(OldDataMonitor.referTo(obj));
                if (isDelete && obj instanceof Job) {
                    for (Run r : ((Job)obj).getBuilds()) {
                        odm.data.remove(OldDataMonitor.referTo(r));
                    }
                }
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)oldContext);
            }
        }
    }

    public static void report(Saveable obj, String version) {
        OldDataMonitor odm = OldDataMonitor.get(Jenkins.getInstance());
        try {
            VersionRange vr;
            SaveableReference ref = OldDataMonitor.referTo(obj);
            while (!((vr = (VersionRange)odm.data.get(ref)) != null && odm.data.replace(ref, vr, new VersionRange(vr, version, null)) || odm.data.putIfAbsent(ref, new VersionRange(null, version, null)) == null)) {
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, "Bad parameter given to OldDataMonitor", ex);
        }
    }

    public static void report(UnmarshallingContext context, String version) {
        RobustReflectionConverter.addErrorInContext(context, new ReportException(version));
    }

    public static void report(Saveable obj, Collection<Throwable> errors) {
        VersionRange vr;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Throwable e : errors) {
            if (e instanceof ReportException) {
                OldDataMonitor.report(obj, ((ReportException)e).version);
                continue;
            }
            if (++i > 1) {
                buf.append(", ");
            }
            buf.append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
        }
        if (buf.length() == 0) {
            return;
        }
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            for (Throwable t : errors) {
                LOGGER.log(Level.WARNING, "could not read " + obj + " (and Jenkins did not start up)", t);
            }
            return;
        }
        OldDataMonitor odm = OldDataMonitor.get(j);
        SaveableReference ref = OldDataMonitor.referTo(obj);
        while (!((vr = (VersionRange)odm.data.get(ref)) != null && odm.data.replace(ref, vr, new VersionRange(vr, null, buf.toString())) || odm.data.putIfAbsent(ref, new VersionRange(null, null, buf.toString())) == null)) {
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Iterator<VersionNumber> getVersionList() {
        TreeSet<VersionNumber> set = new TreeSet<VersionNumber>();
        for (VersionRange vr : this.data.values()) {
            if (vr.max == null) continue;
            set.add(vr.max);
        }
        return set.iterator();
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return new HttpRedirect("manage");
    }

    @RequirePOST
    public HttpResponse doUpgrade(StaplerRequest req, StaplerResponse rsp) {
        String thruVerParam = req.getParameter("thruVer");
        final VersionNumber thruVer = thruVerParam.equals("all") ? null : new VersionNumber(thruVerParam);
        this.saveAndRemoveEntries(new Predicate<Map.Entry<SaveableReference, VersionRange>>(){

            public boolean apply(Map.Entry<SaveableReference, VersionRange> entry) {
                VersionNumber version = entry.getValue().max;
                return version != null && (thruVer == null || !version.isNewerThan(thruVer));
            }
        });
        return HttpResponses.forwardToPreviousPage();
    }

    @RequirePOST
    public HttpResponse doDiscard(StaplerRequest req, StaplerResponse rsp) {
        this.saveAndRemoveEntries(new Predicate<Map.Entry<SaveableReference, VersionRange>>(){

            public boolean apply(Map.Entry<SaveableReference, VersionRange> entry) {
                return entry.getValue().max == null;
            }
        });
        return HttpResponses.forwardToPreviousPage();
    }

    private void saveAndRemoveEntries(Predicate<Map.Entry<SaveableReference, VersionRange>> matchingPredicate) {
        ArrayList removed = new ArrayList();
        for (Map.Entry entry : this.data.entrySet()) {
            if (!matchingPredicate.apply(entry)) continue;
            Saveable s = ((SaveableReference)entry.getKey()).get();
            if (s != null) {
                try {
                    s.save();
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to save " + s, x);
                }
            }
            removed.add(entry.getKey());
        }
        this.data.keySet().removeAll(removed);
    }

    public HttpResponse doIndex(StaplerResponse rsp) throws IOException {
        return new HttpRedirect("manage");
    }

    private static SaveableReference referTo(Saveable s) {
        if (s instanceof Run) {
            Object parent = ((Run)s).getParent();
            if (Jenkins.getInstance().getItemByFullName(((AbstractItem)parent).getFullName()) == parent) {
                return new RunSaveableReference((Run)s);
            }
        }
        return new SimpleSaveableReference(s);
    }

    @Extension
    public static class ManagementLinkImpl
    extends ManagementLink {
        @Override
        public String getIconFileName() {
            return "document.png";
        }

        @Override
        public String getUrlName() {
            return "administrativeMonitor/OldData/";
        }

        @Override
        public String getDescription() {
            return Messages.OldDataMonitor_Description();
        }

        @Override
        public String getDisplayName() {
            return Messages.OldDataMonitor_DisplayName();
        }
    }

    private static final class RunSaveableReference
    implements SaveableReference {
        private final String id;

        RunSaveableReference(Run<?, ?> r) {
            this.id = r.getExternalizableId();
        }

        @Override
        public Saveable get() {
            try {
                return Run.fromExternalizableId(this.id);
            }
            catch (IllegalArgumentException x) {
                LOGGER.log(Level.FINE, null, x);
                return null;
            }
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof RunSaveableReference && this.id.equals(((RunSaveableReference)obj).id);
        }
    }

    private static final class SimpleSaveableReference
    implements SaveableReference {
        private final Saveable instance;

        SimpleSaveableReference(Saveable instance) {
            this.instance = instance;
        }

        @Override
        public Saveable get() {
            return this.instance;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof SimpleSaveableReference && this.instance.equals(((SimpleSaveableReference)obj).instance);
        }
    }

    private static interface SaveableReference {
        @CheckForNull
        public Saveable get();
    }

    public static class VersionRange {
        private static VersionNumber currentVersion = Jenkins.getVersion();
        final VersionNumber min;
        final VersionNumber max;
        final boolean single;
        public final String extra;

        public VersionRange(VersionRange previous, String version, String extra) {
            if (previous == null) {
                this.max = version != null ? new VersionNumber(version) : null;
                this.min = this.max;
                this.single = true;
                this.extra = extra;
            } else if (version == null) {
                this.min = previous.min;
                this.max = previous.max;
                this.single = previous.single;
                this.extra = extra;
            } else {
                VersionNumber ver = new VersionNumber(version);
                this.min = previous.min == null || ver.isOlderThan(previous.min) ? ver : previous.min;
                this.max = previous.max == null || ver.isNewerThan(previous.max) ? ver : previous.max;
                this.single = this.max.isNewerThan(this.min);
                this.extra = extra;
            }
        }

        public String toString() {
            return this.min == null ? "" : this.min.toString() + (this.single ? "" : " - " + this.max.toString());
        }

        public boolean isOld(int threshold) {
            return currentVersion != null && this.min != null && (currentVersion.digit(0) > this.min.digit(0) || currentVersion.digit(0) == this.min.digit(0) && currentVersion.digit(1) - this.min.digit(1) >= threshold);
        }
    }

    private static class ReportException
    extends Exception {
        private String version;

        private ReportException(String version) {
            this.version = version;
        }
    }
}

