/*
 * Decompiled with CFR 0.152.
 */
package hudson.init;

import hudson.PluginManager;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.Service;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.reactor.Task;

public class InitStrategy {
    private static final Logger LOGGER = Logger.getLogger(InitStrategy.class.getName());

    public List<File> listPluginArchives(PluginManager pm) throws IOException {
        ArrayList<File> r = new ArrayList<File>();
        this.getBundledPluginsFromProperty(r);
        Iterator it = r.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            if (!new File(pm.rootDir, f.getName().replace(".hpi", ".jpi") + ".pinned").isFile()) continue;
            LOGGER.log(Level.INFO, "ignoring {0} since this plugin is pinned", f);
            it.remove();
        }
        this.listPluginFiles(pm, ".jpl", r);
        this.listPluginFiles(pm, ".hpl", r);
        this.listPluginFiles(pm, ".jpi", r);
        this.listPluginFiles(pm, ".hpi", r);
        return r;
    }

    private void listPluginFiles(PluginManager pm, String extension, Collection<File> all) throws IOException {
        File[] files = pm.rootDir.listFiles(new FilterByExtension(extension));
        if (files == null) {
            throw new IOException("Jenkins is unable to create " + pm.rootDir + "\nPerhaps its security privilege is insufficient");
        }
        all.addAll(Arrays.asList(files));
    }

    protected void getBundledPluginsFromProperty(final List<File> r) {
        String hplProperty = System.getProperty("hudson.bundled.plugins");
        if (hplProperty != null) {
            for (String hplLocation : hplProperty.split(",")) {
                File hpl = new File(hplLocation.trim());
                if (hpl.exists()) {
                    r.add(hpl);
                    continue;
                }
                if (hpl.getName().contains("*")) {
                    try {
                        new DirScanner.Glob(hpl.getName(), null).scan(hpl.getParentFile(), new FileVisitor(){

                            @Override
                            public void visit(File f, String relativePath) throws IOException {
                                r.add(f);
                            }
                        });
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, "could not expand " + hplLocation, x);
                    }
                    continue;
                }
                LOGGER.warning("bundled plugin " + hplLocation + " does not exist");
            }
        }
    }

    public boolean skipInitTask(Task task) {
        return false;
    }

    public static InitStrategy get(ClassLoader cl) throws IOException {
        List<InitStrategy> r = Service.loadInstances(cl, InitStrategy.class);
        if (r.isEmpty()) {
            return new InitStrategy();
        }
        InitStrategy s = r.get(0);
        LOGGER.fine("Using " + s + " as InitStrategy");
        return s;
    }

    private static class FilterByExtension
    implements FilenameFilter {
        private final List<String> extensions;

        public FilterByExtension(String ... extensions) {
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

