/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractModelObject;
import hudson.model.Node;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@ExtensionPoint.LegacyInstancesAreScopedToHudson
public abstract class AdministrativeMonitor
extends AbstractModelObject
implements ExtensionPoint {
    public final String id;

    protected AdministrativeMonitor(String id) {
        this.id = id;
    }

    protected AdministrativeMonitor() {
        this.id = this.getClass().getName();
    }

    public String getUrl() {
        return "administrativeMonitor/" + this.id;
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public final String getSearchUrl() {
        return this.getUrl();
    }

    public void disable(boolean value) throws IOException {
        Jenkins hudson = Jenkins.getInstance();
        CopyOnWriteArraySet<String> set = hudson.disabledAdministrativeMonitors;
        if (value) {
            set.add(this.id);
        } else {
            set.remove(this.id);
        }
        ((Node)hudson).save();
    }

    public boolean isEnabled() {
        return !Jenkins.getInstance().disabledAdministrativeMonitors.contains(this.id);
    }

    public abstract boolean isActivated();

    public void doDisable(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.disable(true);
        rsp.sendRedirect2(req.getContextPath() + "/manage");
    }

    public static ExtensionList<AdministrativeMonitor> all() {
        return ExtensionList.lookup(AdministrativeMonitor.class);
    }
}

