/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.AperiodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import jenkins.model.Jenkins;

public abstract class AsyncAperiodicWork
extends AperiodicWork {
    public final String name;
    private Thread thread;

    protected AsyncAperiodicWork(String name) {
        this.name = name;
    }

    @Override
    public final void doAperiodicRun() {
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.logger.log(Level.INFO, this.name + " thread is still running. Execution aborted.");
                return;
            }
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AsyncAperiodicWork.this.logger.log(Level.INFO, "Started " + AsyncAperiodicWork.this.name);
                    long startTime = System.currentTimeMillis();
                    StreamTaskListener l = AsyncAperiodicWork.this.createListener();
                    try {
                        ACL.impersonate(ACL.SYSTEM);
                        AsyncAperiodicWork.this.execute(l);
                    }
                    catch (IOException e) {
                        e.printStackTrace(l.fatalError(e.getMessage()));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(l.fatalError("aborted"));
                    }
                    finally {
                        l.closeQuietly();
                    }
                    AsyncAperiodicWork.this.logger.log(Level.INFO, "Finished " + AsyncAperiodicWork.this.name + ". " + (System.currentTimeMillis() - startTime) + " ms");
                }
            }, this.name + " thread");
            this.thread.start();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, this.name + " thread failed with error", t);
        }
    }

    protected StreamTaskListener createListener() {
        try {
            return new StreamTaskListener(this.getLogFile());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected File getLogFile() {
        return new File(Jenkins.getInstance().getRootDir(), this.name + ".log");
    }

    protected abstract void execute(TaskListener var1) throws IOException, InterruptedException;
}

