/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jenkins.model.Jenkins;

public abstract class AsyncPeriodicWork
extends PeriodicWork {
    public final String name;
    private Thread thread;

    protected AsyncPeriodicWork(String name) {
        this.name = name;
    }

    @Override
    public final void doRun() {
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.logger.log(this.getSlowLoggingLevel(), "{0} thread is still running. Execution aborted.", this.name);
                return;
            }
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AsyncPeriodicWork.this.logger.log(AsyncPeriodicWork.this.getNormalLoggingLevel(), "Started {0}", AsyncPeriodicWork.this.name);
                    long startTime = System.currentTimeMillis();
                    StreamTaskListener l = AsyncPeriodicWork.this.createListener();
                    try {
                        ACL.impersonate(ACL.SYSTEM);
                        AsyncPeriodicWork.this.execute(l);
                    }
                    catch (IOException e) {
                        e.printStackTrace(l.fatalError(e.getMessage()));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(l.fatalError("aborted"));
                    }
                    finally {
                        l.closeQuietly();
                    }
                    AsyncPeriodicWork.this.logger.log(AsyncPeriodicWork.this.getNormalLoggingLevel(), "Finished {0}. {1,number} ms", new Object[]{AsyncPeriodicWork.this.name, System.currentTimeMillis() - startTime});
                }
            }, this.name + " thread");
            this.thread.start();
        }
        catch (Throwable t) {
            LogRecord lr = new LogRecord(this.getErrorLoggingLevel(), "{0} thread failed with error");
            lr.setThrown(t);
            lr.setParameters(new Object[]{this.name});
            this.logger.log(lr);
        }
    }

    protected StreamTaskListener createListener() {
        try {
            return new StreamTaskListener(this.getLogFile());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected File getLogFile() {
        return new File(Jenkins.getInstance().getRootDir(), this.name + ".log");
    }

    protected Level getNormalLoggingLevel() {
        return Level.INFO;
    }

    protected Level getSlowLoggingLevel() {
        return this.getNormalLoggingLevel();
    }

    protected Level getErrorLoggingLevel() {
        return Level.SEVERE;
    }

    protected abstract void execute(TaskListener var1) throws IOException, InterruptedException;
}

