/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.BooleanParameterValue;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BooleanParameterDefinition
extends SimpleParameterDefinition {
    private final boolean defaultValue;

    @DataBoundConstructor
    public BooleanParameterDefinition(String name, boolean defaultValue, String description) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof BooleanParameterValue) {
            BooleanParameterValue value = (BooleanParameterValue)defaultValue;
            return new BooleanParameterDefinition(this.getName(), value.value, this.getDescription());
        }
        return this;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        BooleanParameterValue value = (BooleanParameterValue)req.bindJSON(BooleanParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new BooleanParameterValue(this.getName(), Boolean.valueOf(value), this.getDescription());
    }

    @Override
    public BooleanParameterValue getDefaultParameterValue() {
        return new BooleanParameterValue(this.getName(), this.defaultValue, this.getDescription());
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.BooleanParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/boolean.html";
        }
    }
}

