/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.FoldableAction;
import hudson.util.XStream2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CauseAction
implements FoldableAction,
RunAction2 {
    @Deprecated
    private transient Cause cause;
    private List<Cause> causes = new ArrayList<Cause>();

    public CauseAction(Cause c) {
        this.causes.add(c);
    }

    public CauseAction(Cause ... c) {
        this(Arrays.asList(c));
    }

    public CauseAction(Collection<? extends Cause> causes) {
        this.causes.addAll(causes);
    }

    public CauseAction(CauseAction ca) {
        this.causes.addAll(ca.causes);
    }

    @Exported(visibility=2)
    public List<Cause> getCauses() {
        return this.causes;
    }

    public <T extends Cause> T findCause(Class<T> type) {
        for (Cause c : this.causes) {
            if (!type.isInstance(c)) continue;
            return (T)((Cause)type.cast(c));
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Cause";
    }

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return "cause";
    }

    public Map<Cause, Integer> getCauseCounts() {
        LinkedHashMap<Cause, Integer> result = new LinkedHashMap<Cause, Integer>();
        for (Cause c : this.causes) {
            if (c == null) continue;
            Integer i = (Integer)result.get(c);
            result.put(c, i == null ? 1 : i + 1);
        }
        return result;
    }

    @Deprecated
    public String getShortDescription() {
        if (this.causes.isEmpty()) {
            return "N/A";
        }
        return this.causes.get(0).getShortDescription();
    }

    @Override
    public void onLoad(Run<?, ?> owner) {
        for (Cause c : this.causes) {
            if (c == null) continue;
            c.onLoad(owner);
        }
    }

    @Override
    public void onAttached(Run<?, ?> owner) {
        for (Cause c : this.causes) {
            if (c == null) continue;
            c.onAddedTo(owner);
        }
    }

    @Override
    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        CauseAction existing = item.getAction(CauseAction.class);
        if (existing != null) {
            existing.causes.addAll(this.causes);
            return;
        }
        item.addAction(new CauseAction(this));
    }

    public static class ConverterImpl
    extends XStream2.PassthruConverter<CauseAction> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        @Override
        protected void callback(CauseAction ca, UnmarshallingContext context) {
            if (ca.cause != null) {
                if (ca.causes == null) {
                    ca.causes = new ArrayList();
                }
                ca.causes.add(ca.cause);
                OldDataMonitor.report(context, "1.288");
            }
        }
    }
}

