/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class ChoiceParameterDefinition
extends SimpleParameterDefinition {
    public static final String CHOICES_DELIMITER = "\\r?\\n";
    @Deprecated
    public static final String CHOICES_DELIMETER = "\\r?\\n";
    private final List<String> choices;
    private final String defaultValue;

    public static boolean areValidChoices(String choices) {
        String strippedChoices = choices.trim();
        return !StringUtils.isEmpty((String)strippedChoices) && strippedChoices.split("\\r?\\n").length > 0;
    }

    @DataBoundConstructor
    public ChoiceParameterDefinition(String name, String choices, String description) {
        super(name, description);
        this.choices = Arrays.asList(choices.split("\\r?\\n"));
        this.defaultValue = null;
    }

    public ChoiceParameterDefinition(String name, String[] choices, String description) {
        super(name, description);
        this.choices = new ArrayList<String>(Arrays.asList(choices));
        this.defaultValue = null;
    }

    private ChoiceParameterDefinition(String name, List<String> choices, String defaultValue, String description) {
        super(name, description);
        this.choices = choices;
        this.defaultValue = defaultValue;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new ChoiceParameterDefinition(this.getName(), this.choices, value.value, this.getDescription());
        }
        return this;
    }

    @Exported
    public List<String> getChoices() {
        return this.choices;
    }

    public String getChoicesText() {
        return StringUtils.join(this.choices, (String)"\n");
    }

    @Override
    public StringParameterValue getDefaultParameterValue() {
        return new StringParameterValue(this.getName(), this.defaultValue == null ? this.choices.get(0) : this.defaultValue, this.getDescription());
    }

    private StringParameterValue checkValue(StringParameterValue value) {
        if (!this.choices.contains(value.value)) {
            throw new IllegalArgumentException("Illegal choice for parameter " + this.getName() + ": " + value.value);
        }
        return value;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return this.checkValue(value);
    }

    @Override
    public StringParameterValue createValue(String value) {
        return this.checkValue(new StringParameterValue(this.getName(), value, this.getDescription()));
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ChoiceParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/choice.html";
        }

        public FormValidation doCheckChoices(@QueryParameter String value) {
            if (ChoiceParameterDefinition.areValidChoices(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.ChoiceParameterDefinition_MissingChoices());
        }
    }
}

