/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.ProxyConfiguration;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.PageDecorator;
import hudson.util.FormValidation;
import hudson.util.QuotedStringTokenizer;
import hudson.util.TextFile;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DownloadSettings;
import jenkins.model.Jenkins;
import jenkins.util.JSONSignatureValidator;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DownloadService
extends PageDecorator {
    public static boolean neverUpdate = Boolean.getBoolean(DownloadService.class.getName() + ".never");
    public static boolean signatureCheck = !Boolean.getBoolean(DownloadService.class.getName() + ".noSignatureCheck");

    public String generateFragment() {
        if (!DownloadSettings.usePostBack()) {
            return "";
        }
        if (neverUpdate) {
            return "";
        }
        if (this.doesNotSupportPostMessage()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (Jenkins.getInstance().hasPermission(Jenkins.READ)) {
            long now = System.currentTimeMillis();
            for (Downloadable d : Downloadable.all()) {
                if (d.getDue() >= now || d.lastAttempt + 10000L >= now) continue;
                buf.append("<script>").append("Behaviour.addLoadEvent(function() {").append("  downloadService.download(").append(QuotedStringTokenizer.quote(d.getId())).append(',').append(QuotedStringTokenizer.quote(this.mapHttps(d.getUrl()))).append(',').append("{version:" + QuotedStringTokenizer.quote(Jenkins.VERSION) + '}').append(',').append(QuotedStringTokenizer.quote(Stapler.getCurrentRequest().getContextPath() + '/' + this.getUrl() + "/byId/" + d.getId() + "/postBack")).append(',').append("null);").append("});").append("</script>");
                d.lastAttempt = now;
            }
        }
        return buf.toString();
    }

    private boolean doesNotSupportPostMessage() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return false;
        }
        String ua = req.getHeader("User-Agent");
        if (ua == null) {
            return false;
        }
        return ua.contains("Windows") && (ua.contains(" MSIE 5.") || ua.contains(" MSIE 6.") || ua.contains(" MSIE 7."));
    }

    private String mapHttps(String url) {
        if (url.startsWith("http://updates.jenkins-ci.org/") && Jenkins.getInstance().isRootUrlSecure()) {
            return "https" + url.substring(4);
        }
        return url;
    }

    public Downloadable getById(String id) {
        for (Downloadable d : Downloadable.all()) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSON(URL src) throws IOException {
        try (InputStream is = ProxyConfiguration.open(src).getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (String)"UTF-8");
            int start = jsonp.indexOf(123);
            int end = jsonp.lastIndexOf(125);
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start, end + 1);
                return string;
            }
            throw new IOException("Could not find JSON in " + src);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSONHTML(URL src) throws IOException {
        try (InputStream is = ProxyConfiguration.open(src).getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (String)"UTF-8");
            String preamble = "window.parent.postMessage(JSON.stringify(";
            int start = jsonp.indexOf(preamble);
            int end = jsonp.lastIndexOf("),'*');");
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start + preamble.length(), end).trim();
                return string;
            }
            throw new IOException("Could not find JSON in " + src);
        }
    }

    public static class Downloadable
    implements ExtensionPoint {
        private final String id;
        private final String url;
        private final long interval;
        private volatile long due = 0L;
        private volatile long lastAttempt = Long.MIN_VALUE;
        private static final Logger LOGGER = Logger.getLogger(Downloadable.class.getName());
        private static final long DEFAULT_INTERVAL = Long.getLong(Downloadable.class.getName() + ".defaultInterval", TimeUnit2.DAYS.toMillis(1L));

        public Downloadable(String id, String url, long interval) {
            this.id = id;
            this.url = url;
            this.interval = interval;
        }

        public Downloadable() {
            this.id = this.getClass().getName().replace('$', '.');
            this.url = this.id + ".json";
            this.interval = DEFAULT_INTERVAL;
        }

        public Downloadable(Class id) {
            this(id.getName().replace('$', '.'));
        }

        public Downloadable(String id) {
            this(id, id + ".json");
        }

        public Downloadable(String id, String url) {
            this(id, url, DEFAULT_INTERVAL);
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return Jenkins.getInstance().getUpdateCenter().getDefaultBaseUrl() + "updates/" + this.url;
        }

        public long getInterval() {
            return this.interval;
        }

        public TextFile getDataFile() {
            return new TextFile(new File(Jenkins.getInstance().getRootDir(), "updates/" + this.id));
        }

        public long getDue() {
            if (this.due == 0L) {
                this.due = this.getDataFile().file.lastModified() + this.interval;
            }
            return this.due;
        }

        public JSONObject getData() throws IOException {
            TextFile df = this.getDataFile();
            if (df.exists()) {
                try {
                    return JSONObject.fromObject((Object)df.read());
                }
                catch (JSONException e) {
                    df.delete();
                    throw new IOException("Failed to parse " + df + " into JSON", e);
                }
            }
            return null;
        }

        public void doPostBack(StaplerRequest req, StaplerResponse rsp) throws IOException {
            DownloadSettings.checkPostBackAccess();
            long dataTimestamp = System.currentTimeMillis();
            this.due = dataTimestamp + this.getInterval();
            String json = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
            FormValidation e = this.load(json, dataTimestamp);
            if (e.kind != FormValidation.Kind.OK) {
                LOGGER.severe(e.renderHtml());
                throw e;
            }
            rsp.setContentType("text/plain");
        }

        private FormValidation load(String json, long dataTimestamp) throws IOException {
            JSONObject o = JSONObject.fromObject((Object)json);
            if (signatureCheck) {
                FormValidation e = new JSONSignatureValidator("downloadable '" + this.id + "'").verifySignature(o);
                if (e.kind != FormValidation.Kind.OK) {
                    return e;
                }
            }
            TextFile df = this.getDataFile();
            df.write(json);
            df.file.setLastModified(dataTimestamp);
            LOGGER.info("Obtained the updated data file for " + this.id);
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation updateNow() throws IOException {
            return this.load(DownloadService.loadJSONHTML(new URL(this.getUrl() + ".html?id=" + URLEncoder.encode(this.getId(), "UTF-8") + "&version=" + URLEncoder.encode(Jenkins.VERSION, "UTF-8"))), System.currentTimeMillis());
        }

        public static ExtensionList<Downloadable> all() {
            return ExtensionList.lookup(Downloadable.class);
        }

        public static Downloadable get(String id) {
            for (Downloadable d : Downloadable.all()) {
                if (!d.id.equals(id)) continue;
                return d;
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DownloadableListener
    extends ExtensionListListener {
        private static final Logger LOGGER = Logger.getLogger(DownloadableListener.class.getName());

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        public static void installListener() {
            ExtensionList.lookup(Downloadable.class).addListener(new DownloadableListener());
        }

        @Override
        public void onChange() {
            for (Downloadable d : Downloadable.all()) {
                TextFile f = d.getDataFile();
                if (f == null || !f.exists()) {
                    LOGGER.log(Level.FINE, "Updating metadata for " + d.getId());
                    try {
                        d.updateNow();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to update metadata for " + d.getId(), e);
                    }
                    continue;
                }
                LOGGER.log(Level.FINER, "Skipping update of metadata for " + d.getId());
            }
        }
    }
}

